/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.storage.file;

import io.datarouter.filesystem.snapshot.block.BlockType;

public class FileKey {
    public final BlockType type;
    public final int level;
    public final int column;
    public final int fileId;

    public FileKey(BlockType type, int level, int column, int fileId) {
        this.type = type;
        this.level = level;
        this.column = column;
        this.fileId = fileId;
    }

    public static FileKey root() {
        return new FileKey(BlockType.ROOT, -1, -1, -1);
    }

    public static FileKey branch(int level, int fileId) {
        return new FileKey(BlockType.BRANCH, level, -1, fileId);
    }

    public static FileKey leaf(int fileId) {
        return new FileKey(BlockType.LEAF, -1, -1, fileId);
    }

    public static FileKey value(int column, int fileId) {
        return new FileKey(BlockType.VALUE, -1, column, fileId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + this.fileId;
        result = 31 * result + this.level;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileKey other = (FileKey)obj;
        if (this.column != other.column) {
            return false;
        }
        if (this.fileId != other.fileId) {
            return false;
        }
        if (this.level != other.level) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return "FileKey [type=" + (Object)((Object)this.type) + ", " + "level=" + this.level + ", " + "column=" + this.column + ", " + "fileId=" + this.fileId + "]";
    }
}

