/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.storage.file;

import io.datarouter.filesystem.snapshot.block.BlockKey;
import io.datarouter.filesystem.snapshot.compress.CompressedBlock;
import io.datarouter.filesystem.snapshot.compress.CompressedBlocks;
import io.datarouter.filesystem.snapshot.encode.EncodedBlock;
import io.datarouter.filesystem.snapshot.path.SnapshotPaths;
import io.datarouter.filesystem.snapshot.storage.file.FileKey;
import io.datarouter.filesystem.snapshot.storage.file.SnapshotFileStorage;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.file.Directory;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.util.Subpath;
import java.util.List;
import java.util.stream.Collectors;

public class BlobStorageSnapshotFileStorage
implements SnapshotFileStorage {
    private static final boolean USE_CHUNK_WRITER = true;
    private final Directory directory;

    public BlobStorageSnapshotFileStorage(Directory directory) {
        this.directory = directory;
    }

    @Override
    public void addRootFile(EncodedBlock encodedBlock) {
        this.add(SnapshotPaths.rootFile(), new CompressedBlocks(List.of(new CompressedBlock(encodedBlock.chunks))));
    }

    @Override
    public void addBranchFile(SnapshotPaths paths, FileKey fileKey, CompressedBlocks compressedBlocks) {
        this.add(paths.branchFile(fileKey), compressedBlocks);
    }

    @Override
    public void addLeafFile(SnapshotPaths paths, FileKey fileKey, CompressedBlocks compressedBlocks) {
        this.add(paths.leafFile(fileKey), compressedBlocks);
    }

    @Override
    public void addValueFile(SnapshotPaths paths, FileKey fileKey, CompressedBlocks compressedBlocks) {
        this.add(paths.valueFile(fileKey), compressedBlocks);
    }

    private void add(String path, CompressedBlocks compressedBlocks) {
        Scanner<byte[]> chunks = compressedBlocks.chunkScanner();
        this.directory.write(PathbeanKey.of((String)path), chunks);
    }

    @Override
    public byte[] getRootBlock() {
        return this.directory.read(PathbeanKey.of((String)SnapshotPaths.rootFile()));
    }

    @Override
    public byte[] getBranchBlock(SnapshotPaths paths, BlockKey blockKey) {
        return this.getBlock(paths.branchFile(blockKey.toFileKey()), blockKey.offset, blockKey.length);
    }

    @Override
    public byte[] getLeafBlock(SnapshotPaths paths, BlockKey blockKey) {
        return this.getBlock(paths.leafFile(blockKey.toFileKey()), blockKey.offset, blockKey.length);
    }

    @Override
    public byte[] getValueBlock(SnapshotPaths paths, BlockKey blockKey) {
        return this.getBlock(paths.valueFile(blockKey.toFileKey()), blockKey.offset, blockKey.length);
    }

    private byte[] getBlock(String path, int offset, int length) {
        return this.directory.read(PathbeanKey.of((String)path), (long)offset, length);
    }

    @Override
    public void deleteRootFile() {
        this.delete(SnapshotPaths.rootFile());
    }

    @Override
    public void deleteBranchFile(SnapshotPaths paths, FileKey fileKey) {
        this.delete(paths.branchFile(fileKey));
    }

    @Override
    public void deleteLeafFile(SnapshotPaths paths, FileKey fileKey) {
        this.delete(paths.leafFile(fileKey));
    }

    @Override
    public void deleteValueFile(SnapshotPaths paths, FileKey fileKey) {
        this.delete(paths.valueFile(fileKey));
    }

    private void delete(String path) {
        this.directory.delete(PathbeanKey.of((String)path));
    }

    @Override
    public void deleteAll() {
        this.directory.deleteAll(Subpath.empty());
    }

    @Override
    public String toStringDebug() {
        return "\n" + (String)this.directory.scanKeys(Subpath.empty()).map(Object::toString).sort().collect(Collectors.joining("\n"));
    }
}

