/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.group.vacuum;

import io.datarouter.filesystem.snapshot.group.vacuum.SnapshotVacuumConfig;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.filesystem.snapshot.key.SnapshotKeyDecoder;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.UlidTool;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class SnapshotVacuumPlanner {
    private final SnapshotVacuumConfig config;
    private final SnapshotKeyDecoder keyDecoder;
    private final List<SnapshotKey> ascKeys;

    public SnapshotVacuumPlanner(SnapshotVacuumConfig config, SnapshotKeyDecoder keyDecoder, List<SnapshotKey> ascKeys) {
        this.config = config;
        this.keyDecoder = keyDecoder;
        this.ascKeys = ascKeys;
    }

    public SnapshotVacuumPlan plan() {
        SnapshotVacuumPlan plan = new SnapshotVacuumPlan();
        LinkedHashSet remainingCandidatesDesc = (LinkedHashSet)Scanner.of(this.ascKeys).reverse().skip((long)this.config.getMinVersions()).collect(LinkedHashSet::new);
        this.config.optTtl().ifPresent(ttl -> {
            List keysToVacuumForTtl = Scanner.of((Iterable)remainingCandidatesDesc).include(snapshotKey -> this.keyDecoder.isOlderThan((SnapshotKey)snapshotKey, (Duration)ttl)).list();
            Scanner.of((Iterable)keysToVacuumForTtl).each(remainingCandidatesDesc::remove).map(snapshotKey -> new SnapshotVacuumPlanItem((SnapshotKey)snapshotKey, String.format("age=%s exceeds ttl=%s", this.keyDecoder.getAge((SnapshotKey)snapshotKey), ttl))).forEach(plan::add);
        });
        this.config.optMaxVersions().ifPresent(maxVersions -> {
            int remainingKeep = maxVersions - this.config.getMinVersions();
            List keysToVacuumForMaxVersions = Scanner.of((Iterable)remainingCandidatesDesc).skip((long)remainingKeep).list();
            Scanner.of((Iterable)keysToVacuumForMaxVersions).each(remainingCandidatesDesc::remove).map(snapshotKey -> new SnapshotVacuumPlanItem((SnapshotKey)snapshotKey, String.format("exceeds maxVersions=%s", maxVersions))).forEach(plan::add);
        });
        return plan;
    }

    public static class SnapshotVacuumPlan {
        public String id = UlidTool.nextUlid();
        public List<SnapshotVacuumPlanItem> items = new ArrayList<SnapshotVacuumPlanItem>();

        void add(SnapshotVacuumPlanItem item) {
            this.items.add(item);
        }
    }

    public static class SnapshotVacuumPlanItem {
        public final SnapshotKey snapshotKey;
        public final String reason;

        public SnapshotVacuumPlanItem(SnapshotKey snapshotKey, String reason) {
            this.snapshotKey = snapshotKey;
            this.reason = reason;
        }
    }
}

