/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.datarouter.filesystem.snapshot.block.Block;
import io.datarouter.filesystem.snapshot.block.BlockKey;
import io.datarouter.filesystem.snapshot.block.leaf.LeafBlock;
import io.datarouter.filesystem.snapshot.reader.block.BlockLoader;
import io.datarouter.filesystem.snapshot.reader.block.LeafBlockRangeLoader;
import io.datarouter.scanner.Scanner;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class MemoryBlockCache
implements BlockLoader {
    private final LoadingCache<BlockKey, Block> blocks;

    public MemoryBlockCache(int maxSizeBytes, BlockLoader blockLoader) {
        this.blocks = Caffeine.newBuilder().executor((Executor)Executors.newCachedThreadPool()).maximumWeight((long)maxSizeBytes).weigher((key, block) -> block.heapSize()).build(blockLoader::get);
    }

    @Override
    public Scanner<LeafBlock> leafRange(LeafBlockRangeLoader.LeafBlockRange range) {
        return Scanner.of(range.blockKeys).map(this::leaf);
    }

    @Override
    public Block get(BlockKey key) {
        return (Block)this.blocks.get((Object)key);
    }
}

