/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.block;

public class BlockSizeCalculator {
    private static final int WORD_WIDTH = 8;
    private int size;

    public static int pad(int inputSize) {
        int overflow = inputSize % 8;
        int padding = 8 - overflow;
        return inputSize + padding;
    }

    public int calculate() {
        return BlockSizeCalculator.pad(this.size);
    }

    public BlockSizeCalculator addObjectHeaders(int num) {
        this.size += num * 16;
        return this;
    }

    public BlockSizeCalculator addRefs(int num) {
        this.size += num * 8;
        return this;
    }

    public BlockSizeCalculator addArrays(int num) {
        this.size += num * 24;
        return this;
    }

    public BlockSizeCalculator addLongs(int num) {
        this.size += num * 8;
        return this;
    }

    public BlockSizeCalculator addDoubles(int num) {
        this.size += num * 8;
        return this;
    }

    public BlockSizeCalculator addInts(int num) {
        this.size += num * 4;
        return this;
    }

    public BlockSizeCalculator addFloats(int num) {
        this.size += num * 4;
        return this;
    }

    public BlockSizeCalculator addChars(int num) {
        this.size += num * 2;
        return this;
    }

    public BlockSizeCalculator addShorts(int num) {
        this.size += num * 2;
        return this;
    }

    public BlockSizeCalculator addBytes(int num) {
        this.size += num;
        return this;
    }

    public BlockSizeCalculator addBooleans(int num) {
        this.size += num;
        return this;
    }

    public BlockSizeCalculator addByteArrayValue(byte[] array) {
        this.addArrays(1);
        this.addBytes(BlockSizeCalculator.pad(array.length));
        return this;
    }

    public BlockSizeCalculator addIntArrayValue(int[] array) {
        this.addArrays(1);
        this.addBytes(BlockSizeCalculator.pad(4 * array.length));
        return this;
    }

    public BlockSizeCalculator addStringValue(String string) {
        this.addObjectHeaders(1);
        this.addArrays(1);
        this.addBytes(BlockSizeCalculator.pad(string.length()));
        this.addBytes(1);
        this.addInts(1);
        this.addBooleans(1);
        return this;
    }
}

