/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.block;

import io.datarouter.filesystem.snapshot.block.BlockType;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.filesystem.snapshot.storage.block.CacheBlockKey;
import io.datarouter.filesystem.snapshot.storage.file.FileKey;

public class BlockKey {
    public final SnapshotKey snapshotKey;
    public final BlockType type;
    public final int level;
    public final int column;
    public final int blockId;
    public final int fileId;
    public final int offset;
    public final int length;

    private BlockKey(SnapshotKey snapshotKey, BlockType type, int level, int column, int blockId, int fileId, int offset, int length) {
        this.snapshotKey = snapshotKey;
        this.type = type;
        this.level = level;
        this.column = column;
        this.blockId = blockId;
        this.fileId = fileId;
        this.offset = offset;
        this.length = length;
    }

    public static BlockKey root(SnapshotKey snapshotKey) {
        return new BlockKey(snapshotKey, BlockType.ROOT, -1, -1, -1, -1, -1, -1);
    }

    public static BlockKey branchRoot(SnapshotKey snapshotKey, int maxLevel, int length) {
        return BlockKey.branch(snapshotKey, maxLevel, 0, 0, 0, length);
    }

    public static BlockKey branch(SnapshotKey snapshotKey, int level, int blockId, int fileId, int offset, int length) {
        return new BlockKey(snapshotKey, BlockType.BRANCH, level, -1, blockId, fileId, offset, length);
    }

    public static BlockKey leaf(SnapshotKey snapshotKey, int blockId, int fileId, int offset, int length) {
        return new BlockKey(snapshotKey, BlockType.LEAF, -1, -1, blockId, fileId, offset, length);
    }

    public static BlockKey value(SnapshotKey snapshotKey, int column, int blockId, int fileId, int offset, int length) {
        return new BlockKey(snapshotKey, BlockType.VALUE, -1, column, blockId, fileId, offset, length);
    }

    public FileKey toFileKey() {
        return new FileKey(this.type, this.level, this.column, this.fileId);
    }

    public CacheBlockKey toCacheBlockKey() {
        return new CacheBlockKey(this.snapshotKey, this.type, this.level, this.column, this.blockId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + this.fileId;
        result = 31 * result + this.blockId;
        result = 31 * result + this.length;
        result = 31 * result + this.level;
        result = 31 * result + this.offset;
        result = 31 * result + (this.snapshotKey == null ? 0 : this.snapshotKey.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockKey other = (BlockKey)obj;
        if (this.column != other.column) {
            return false;
        }
        if (this.fileId != other.fileId) {
            return false;
        }
        if (this.blockId != other.blockId) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (this.level != other.level) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        if (this.snapshotKey == null ? other.snapshotKey != null : !this.snapshotKey.equals(other.snapshotKey)) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return "BlockKey [snapshotKey=" + this.snapshotKey + ", " + "type=" + (Object)((Object)this.type) + ", " + "level=" + this.level + ", " + "column=" + this.column + ", " + "blockId=" + this.blockId + ", " + "fileId=" + this.fileId + ", " + "offset=" + this.offset + ", " + "length=" + this.length + "]";
    }
}

