/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.raw.small;

import io.datarouter.filesystem.raw.small.BinaryFileService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class Utf8SmallFileService {
    @Inject
    private CheckedUtf8FileService checkedService;

    public void writeUtf8(Path fullPath, String contents) {
        try {
            this.checkedService.writeUtf8(fullPath, contents);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String readUtf8(Path fullPath) {
        try {
            return this.checkedService.readUtf8(fullPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Singleton
    public static class CheckedUtf8FileService {
        @Inject
        private BinaryFileService binaryFileService;

        public void writeUtf8(Path fullPath, String contents) throws UnsupportedEncodingException {
            this.binaryFileService.writeBytes(fullPath, contents.getBytes(StandardCharsets.UTF_8.name()));
        }

        public String readUtf8(Path fullPath) throws IOException {
            byte[] bytes = Files.readAllBytes(fullPath);
            return new String(bytes, StandardCharsets.UTF_8);
        }
    }
}

