/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.reader.block;

import io.datarouter.filesystem.snapshot.block.BlockKey;
import io.datarouter.filesystem.snapshot.block.branch.BranchBlock;
import io.datarouter.filesystem.snapshot.block.leaf.LeafBlock;
import io.datarouter.filesystem.snapshot.block.root.RootBlock;
import io.datarouter.filesystem.snapshot.block.value.ValueBlock;
import io.datarouter.filesystem.snapshot.compress.BlockDecompressor;
import io.datarouter.filesystem.snapshot.encode.BlockDecoder;
import io.datarouter.filesystem.snapshot.path.SnapshotPaths;
import io.datarouter.filesystem.snapshot.reader.block.BlockLoader;
import io.datarouter.filesystem.snapshot.reader.block.LeafBlockRangeLoader;
import io.datarouter.filesystem.snapshot.storage.block.SnapshotBlockStorageReader;
import io.datarouter.model.util.Bytes;
import io.datarouter.scanner.Scanner;

public class DecodingBlockLoader
implements BlockLoader {
    private final SnapshotBlockStorageReader snapshotBlockStorageReader;
    private final SnapshotPaths paths;
    private final BlockDecompressor blockDecompressor;
    private final BlockDecoder blockDecoder;

    public DecodingBlockLoader(SnapshotBlockStorageReader snapshotBlockStorageReader, SnapshotPaths paths, BlockDecompressor blockDecompressor, BlockDecoder blockDecoder) {
        this.snapshotBlockStorageReader = snapshotBlockStorageReader;
        this.paths = paths;
        this.blockDecompressor = blockDecompressor;
        this.blockDecoder = blockDecoder;
    }

    @Override
    public RootBlock root(BlockKey key) {
        byte[] encodedBytes = this.snapshotBlockStorageReader.getRootBlock();
        return this.blockDecoder.root(encodedBytes);
    }

    @Override
    public BranchBlock branch(BlockKey key) {
        byte[] compressedBytes = this.snapshotBlockStorageReader.getBranchBlock(this.paths, key);
        byte[] encodedBytes = this.blockDecompressor.branch(compressedBytes);
        return this.blockDecoder.branch(encodedBytes);
    }

    @Override
    public LeafBlock leaf(BlockKey key) {
        byte[] compressedBytes = this.snapshotBlockStorageReader.getLeafBlock(this.paths, key);
        byte[] encodedBytes = this.blockDecompressor.leaf(compressedBytes);
        return this.blockDecoder.leaf(encodedBytes);
    }

    @Override
    public Scanner<LeafBlock> leafRange(LeafBlockRangeLoader.LeafBlockRange range) {
        BlockKey rangeBlockKey = range.rangeBlockKey();
        byte[] compressedRangeBytes = this.snapshotBlockStorageReader.getLeafBlock(this.paths, rangeBlockKey);
        return range.parse(compressedRangeBytes).map(Bytes::toArray).map(this.blockDecompressor::leaf).map(this.blockDecoder::leaf);
    }

    @Override
    public ValueBlock value(BlockKey key) {
        byte[] compressedBytes = this.snapshotBlockStorageReader.getValueBlock(this.paths, key);
        byte[] encodedBytes = this.blockDecompressor.value(compressedBytes);
        return this.blockDecoder.value(encodedBytes);
    }
}

