/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.compress;

import io.datarouter.filesystem.snapshot.compress.CompressedBlock;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.bytes.ByteTool;
import java.util.List;

public class CompressedBlocks {
    public final List<CompressedBlock> blocks;
    public final int count;
    public final int totalLength;

    public CompressedBlocks(List<CompressedBlock> blocks) {
        this.blocks = blocks;
        this.count = blocks.size();
        this.totalLength = blocks.stream().mapToInt(block -> block.totalLength).sum();
    }

    public Scanner<byte[]> chunkScanner() {
        return Scanner.of(this.blocks).map(block -> block.chunks).concat(byArray -> Scanner.of((Object[])byArray));
    }

    public byte[] concat() {
        return (byte[])Scanner.of(this.blocks).map(block -> block.chunks).concat(byArray -> Scanner.of((Object[])byArray)).listTo(ByteTool::concatenate);
    }
}

