/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.compress;

import io.datarouter.filesystem.snapshot.compress.BlockCompressor;
import io.datarouter.filesystem.snapshot.compress.CompressedBlock;
import io.datarouter.filesystem.snapshot.encode.EncodedBlock;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GzipBlockCompressor
implements BlockCompressor {
    public static final String NAME = "gzip";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public CompressedBlock compress(EncodedBlock encodedBlock, boolean concatChunks) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);){
                int i = 0;
                while (i < encodedBlock.chunks.length) {
                    gzipOutputStream.write(encodedBlock.chunks[i], 0, encodedBlock.chunks[i].length);
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new CompressedBlock(new byte[][]{outputStream.toByteArray()});
    }

    @Override
    public byte[] decompress(byte[] bytes, boolean validateChecksum) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (GZIPInputStream gzipInputStream = new GZIPInputStream(inputStream);){
                return gzipInputStream.readAllBytes();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

