/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.web;

import io.datarouter.filesystem.snapshot.group.SnapshotGroups;
import io.datarouter.filesystem.snapshot.web.DatarouterSnapshotExecutors;
import io.datarouter.filesystem.snapshot.web.DatarouterSnapshotPaths;
import io.datarouter.scanner.ParallelScannerContext;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import io.datarouter.web.requirejs.DatarouterWebRequireJsV2;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.H4Tag;
import j2html.tags.specialized.TableTag;
import j2html.tags.specialized.TheadTag;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import org.apache.http.client.utils.URIBuilder;

public class DatarouterSnapshotGroupsHandler
extends BaseHandler {
    private static final String P_groupId = "groupId";
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private DatarouterSnapshotPaths snapshotPaths;
    @Inject
    private SnapshotGroups groups;
    @Inject
    private DatarouterSnapshotExecutors.DatarouterSnapshotWebExecutor exec;

    @BaseHandler.Handler
    public Mav listGroups() {
        return this.pageFactory.startBuilder(this.request).withTitle("Datarouter Filesystem - Snapshot Groups").withRequires(new String[]{DatarouterWebRequireJsV2.SORTTABLE}).withContent(this.buildGroupList()).buildMav();
    }

    private ContainerTag buildGroupList() {
        TheadTag thead = TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"ID"), TagCreator.th((String)"numSnapshots")})});
        TableTag table = (TableTag)((TableTag)TagCreator.table().withClasses(new String[]{"sortable table table-sm table-striped my-4 border"})).with((DomContent)thead);
        this.groups.scanIds().sort().parallel(new ParallelScannerContext((ExecutorService)((Object)this.exec), this.exec.getMaximumPoolSize(), false)).map(id -> {
            String href = new URIBuilder().setPath(String.valueOf(this.request.getContextPath()) + this.snapshotPaths.datarouter.snapshot.group.listSnapshots.toSlashedString()).addParameter(P_groupId, id).toString();
            ATag anchor = (ATag)TagCreator.a((String)id).withHref(href);
            String numSnapshots = String.valueOf(this.groups.getGroup((String)id).keyReadOps(false).scanSnapshotKeys().count());
            return TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((DomContent[])new DomContent[]{anchor}), TagCreator.td((String)numSnapshots)});
        }).forEach(arg_0 -> ((TableTag)table).with(arg_0));
        H4Tag header = TagCreator.h4((String)"Snapshot Groups");
        return (ContainerTag)((DivTag)TagCreator.div((DomContent[])new DomContent[]{header, table}).withClass("container-fluid my-4")).withStyle("padding-left: 0px");
    }
}

