/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.util;

import io.datarouter.scanner.BaseLinkedScanner;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.file.Pathbean;
import java.util.ArrayList;
import java.util.List;

public class PathbeanBatchingScanner
extends BaseLinkedScanner<Pathbean, List<Pathbean>> {
    private final long maxBytes;
    private final int maxPathbeans;
    private List<Pathbean> batch = new ArrayList<Pathbean>();
    private long batchBytes = 0L;
    private boolean finished = false;

    public PathbeanBatchingScanner(Scanner<Pathbean> input, long maxBytes, int maxPathbeans) {
        super(input);
        this.maxBytes = maxBytes;
        this.maxPathbeans = maxPathbeans;
    }

    public boolean advanceInternal() {
        if (this.finished) {
            return false;
        }
        boolean advanced = false;
        while (this.input.advance()) {
            boolean exceedsMax;
            Pathbean pathbean = (Pathbean)this.input.current();
            long numBytes = pathbean.getSize();
            long wouldBeBytes = this.batchBytes + numBytes;
            int wouldBePathbeans = this.batch.size() + 1;
            boolean hasAtLeastOne = this.batch.size() > 0;
            boolean exceedsMaxBytes = wouldBeBytes > this.maxBytes;
            boolean exceedsMaxPathbeans = wouldBePathbeans > this.maxPathbeans;
            boolean bl = exceedsMax = exceedsMaxBytes || exceedsMaxPathbeans;
            if (hasAtLeastOne && exceedsMax) {
                this.current = this.batch;
                this.batch = new ArrayList<Pathbean>();
                this.batchBytes = 0L;
                advanced = true;
            }
            this.batch.add(pathbean);
            this.batchBytes += numBytes;
            if (!advanced) continue;
            return true;
        }
        this.finished = true;
        this.current = this.batch;
        return !((List)this.current).isEmpty();
    }
}

