/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.storage.block;

import io.datarouter.filesystem.snapshot.block.BlockKey;
import io.datarouter.filesystem.snapshot.compress.CompressedBlock;
import io.datarouter.filesystem.snapshot.encode.EncodedBlock;
import io.datarouter.filesystem.snapshot.path.SnapshotPaths;
import io.datarouter.filesystem.snapshot.storage.block.CacheBlockKey;
import io.datarouter.filesystem.snapshot.storage.block.SnapshotBlockStorage;
import io.datarouter.storage.file.Directory;
import io.datarouter.storage.file.PathbeanKey;

public class BlobStorageSnapshotBlockStorage
implements SnapshotBlockStorage {
    private final Directory blobStorage;

    public BlobStorageSnapshotBlockStorage(Directory blobStorage) {
        this.blobStorage = blobStorage;
    }

    @Override
    public void addRootBlock(EncodedBlock encodedBlock) {
        this.add(SnapshotPaths.rootFile(), new CompressedBlock(encodedBlock.chunks));
    }

    @Override
    public void addBranchBlock(SnapshotPaths paths, CacheBlockKey cacheBlockKey, CompressedBlock block) {
        this.add(paths.branchBlock(cacheBlockKey), block);
    }

    @Override
    public void addLeafBlock(SnapshotPaths paths, CacheBlockKey cacheBlockKey, CompressedBlock block) {
        this.add(paths.leafBlock(cacheBlockKey), block);
    }

    @Override
    public void addValueBlock(SnapshotPaths paths, CacheBlockKey cacheBlockKey, CompressedBlock block) {
        this.add(paths.valueBlock(cacheBlockKey), block);
    }

    private void add(String path, CompressedBlock block) {
        this.blobStorage.write(PathbeanKey.of((String)path), block.chunkIterator());
    }

    @Override
    public byte[] getRootBlock() {
        return this.getBlock(SnapshotPaths.rootBlock());
    }

    @Override
    public byte[] getBranchBlock(SnapshotPaths paths, BlockKey blockKey) {
        return this.getBlock(paths.branchBlock(blockKey.toCacheBlockKey()));
    }

    @Override
    public byte[] getLeafBlock(SnapshotPaths paths, BlockKey blockKey) {
        return this.getBlock(paths.leafBlock(blockKey.toCacheBlockKey()));
    }

    @Override
    public byte[] getValueBlock(SnapshotPaths paths, BlockKey blockKey) {
        return this.getBlock(paths.valueBlock(blockKey.toCacheBlockKey()));
    }

    private byte[] getBlock(String path) {
        return this.blobStorage.read(PathbeanKey.of((String)path));
    }

    @Override
    public void deleteRootBlock() {
        this.delete(SnapshotPaths.rootFile());
    }

    @Override
    public void deleteBranchBlock(SnapshotPaths paths, CacheBlockKey cacheBlockKey) {
        this.delete(paths.branchBlock(cacheBlockKey));
    }

    @Override
    public void deleteLeafBlock(SnapshotPaths paths, CacheBlockKey cacheBlockKey) {
        this.delete(paths.leafBlock(cacheBlockKey));
    }

    @Override
    public void deleteValueBlock(SnapshotPaths paths, CacheBlockKey cacheBlockKey) {
        this.delete(paths.valueBlock(cacheBlockKey));
    }

    private void delete(String path) {
        this.blobStorage.delete(PathbeanKey.of((String)path));
    }
}

