/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.block.branch;

import io.datarouter.filesystem.snapshot.block.Block;
import io.datarouter.filesystem.snapshot.block.BlockKey;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.model.util.Bytes;
import io.datarouter.scanner.Scanner;

public interface BranchBlock
extends Block {
    public static final boolean LOG_COMPARISONS = false;

    public int level();

    public int numRecords();

    public long recordId(int var1);

    public Bytes key(int var1);

    public Scanner<Bytes> keys();

    default public Bytes lastKey() {
        return this.key(this.numRecords() - 1);
    }

    default public Scanner<byte[]> keyCopies() {
        return this.keys().map(Bytes::toArray);
    }

    public int childBlock(int var1);

    default public long lastRecordId() {
        return this.recordId(this.numRecords());
    }

    default public int findChildBlockIndex(long recordId) {
        int numRecords = this.numRecords();
        int low = 0;
        int high = numRecords - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = this.recordId(mid);
            int diff = Long.compare(midVal, recordId);
            if (diff < 0) {
                low = mid + 1;
                continue;
            }
            if (diff > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low;
    }

    default public int findChildBlockIndex(byte[] searchKey) {
        Bytes searchKeyRange = new Bytes(searchKey);
        int numKeys = this.numRecords();
        int low = 0;
        int high = numKeys - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Bytes midVal = this.key(mid);
            int diff = midVal.compareTo(searchKeyRange);
            if (diff < 0) {
                low = mid + 1;
                continue;
            }
            if (diff > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low;
    }

    public Scanner<Integer> childBlockIds();

    public BlockKey childBranchBlockKey(SnapshotKey var1, int var2);

    public BlockKey leafBlockKey(SnapshotKey var1, int var2);

    public String toDetailedString();
}

