/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.node.object;

import io.datarouter.filesystem.raw.DirectoryManager;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.file.Pathbean;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.util.Subpath;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class DirectoryBlobStorage {
    private final DirectoryManager directoryManager;

    public DirectoryBlobStorage(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public String getRoot() {
        return this.directoryManager.getRoot().toString();
    }

    public boolean exists(PathbeanKey key) {
        return this.directoryManager.exists(key.getPathAndFile());
    }

    public Optional<Long> length(PathbeanKey key) {
        return this.directoryManager.length(key.getPathAndFile());
    }

    public byte[] read(PathbeanKey key) {
        return this.directoryManager.read(key.getPathAndFile());
    }

    public byte[] read(PathbeanKey key, long offset, int length) {
        return this.directoryManager.read(key.getPathAndFile(), offset, length);
    }

    public void write(PathbeanKey key, byte[] bytes) {
        this.write(key, List.of(bytes).iterator());
    }

    public void write(PathbeanKey key, Iterator<byte[]> chunks) {
        this.directoryManager.write(key.getPathAndFile(), chunks);
    }

    public void write(PathbeanKey key, InputStream inputStream) {
        this.directoryManager.write(key.getPathAndFile(), inputStream);
    }

    public Scanner<List<Pathbean>> scanPaged(Subpath subpath) {
        return this.directoryManager.scanDescendantsPaged(subpath, false, true).map(paths -> Scanner.of((Iterable)paths).map(path -> {
            PathbeanKey key = PathbeanKey.of((Path)path);
            Long size = this.directoryManager.size(key.getPathAndFile());
            return new Pathbean(key, size);
        }).list());
    }

    public Scanner<List<PathbeanKey>> scanKeysPaged(Subpath subpath) {
        return this.directoryManager.scanDescendantsPaged(subpath, false, true).map(paths -> Scanner.of((Iterable)paths).map(PathbeanKey::of).list());
    }

    public void delete(PathbeanKey key) {
        this.directoryManager.delete(key.getPathAndFile());
    }

    public void deleteAll(Subpath subpath) {
        this.directoryManager.deleteDescendants(subpath);
        this.directoryManager.delete(subpath.toString());
    }
}

