/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.raw;

import io.datarouter.filesystem.raw.PathService;
import io.datarouter.filesystem.raw.small.BinaryFileService;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.util.Subpath;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryManager {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryManager.class);
    private static final boolean ALLOW_LOGGING = false;
    private final PathService pathService;
    private final BinaryFileService binaryFileService;
    private final Path root;

    public DirectoryManager(PathService pathService, BinaryFileService binaryFileService, String rootPathString) {
        this.pathService = pathService;
        this.binaryFileService = binaryFileService;
        this.root = Paths.get(rootPathString, new String[0]);
        boolean createdAnyParents = this.root.toFile().mkdirs();
        if (createdAnyParents) {
            logger.warn("created missing directories for {}", (Object)this.root);
        }
    }

    private Path resolve(Path relativePath) {
        return this.root.resolve(relativePath);
    }

    private Path resolveSubpath(Subpath subpath) {
        return this.resolveString(subpath.toString());
    }

    private Path resolveString(String relativePathString) {
        return this.resolve(Paths.get(relativePathString, new String[0]));
    }

    private Path afterRoot(Path path) {
        return path.subpath(this.root.getNameCount(), path.getNameCount());
    }

    private Subpath afterRootSubpath(Path path) {
        return (Subpath)Scanner.of((Iterable)this.afterRoot(path)).map(Path::toString).listTo(Subpath::new);
    }

    public boolean exists(String relativePathString) {
        return Files.exists(this.resolveString(relativePathString), new LinkOption[0]);
    }

    public Optional<Long> length(String relativePathString) {
        try {
            return Optional.of(Files.size(this.resolveString(relativePathString)));
        }
        catch (NoSuchFileException e) {
            return Optional.empty();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public DirectoryManager createSubdirectory(Subpath subpath) {
        return new DirectoryManager(this.pathService, this.binaryFileService, this.resolveSubpath(subpath).toString());
    }

    public Scanner<Path> scanChildren(Subpath subpath, Set<String> excludingFilenames, int limit, boolean sorted) {
        return Scanner.of(this.pathService.listChildren(this.resolveSubpath(subpath), excludingFilenames, limit, sorted)).map(this::afterRoot);
    }

    public Scanner<List<Path>> scanDescendantsPaged(Subpath subpath, boolean includeDirectories, boolean sorted) {
        return this.pathService.scanDescendantsPaged(this.resolveSubpath(subpath), includeDirectories, sorted).map(page -> Scanner.of((Iterable)page).map(this::afterRoot).list());
    }

    public Long size(String relativePathString) {
        return this.pathService.size(this.resolveString(relativePathString));
    }

    public DirectoryManager write(String relativePathString, byte[] bytes) {
        this.binaryFileService.writeBytes(this.resolveString(relativePathString), bytes);
        return this;
    }

    public DirectoryManager write(String relativePathString, InputStream inputStream) {
        this.binaryFileService.writeBytes(this.resolveString(relativePathString), inputStream);
        return this;
    }

    public byte[] read(String relativePathString) {
        return this.binaryFileService.readBytes(this.resolveString(relativePathString));
    }

    public byte[] read(String relativePathString, long offset, int length) {
        return this.binaryFileService.readBytes(this.resolveString(relativePathString), offset, length);
    }

    public InputStream readInputStream(String relativePathString) {
        return this.binaryFileService.readInputStream(this.resolveString(relativePathString));
    }

    public DirectoryManager delete(String relativePathString) {
        this.pathService.delete(this.resolveString(relativePathString));
        return this;
    }

    public DirectoryManager deleteDescendants(Subpath subpath) {
        this.scanChildren(subpath, Set.of(), Integer.MAX_VALUE, false).map(this::resolve).each(path -> {
            if (Files.isDirectory(path, new LinkOption[0])) {
                this.deleteDescendants(this.afterRootSubpath((Path)path));
            }
        }).forEach(this.pathService::delete);
        return this;
    }

    public void selfDestruct() {
        this.deleteDescendants(Subpath.empty());
        this.pathService.delete(this.root);
    }

    public Path getRoot() {
        return this.root;
    }

    @Singleton
    public static class DirectoryManagerFactory {
        @Inject
        private PathService pathService;
        @Inject
        private BinaryFileService binaryFileService;

        public DirectoryManager create(String rootPathString) {
            return new DirectoryManager(this.pathService, this.binaryFileService, rootPathString);
        }
    }
}

