/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.node.queue;

import io.datarouter.bytes.Codec;
import io.datarouter.bytes.codec.stringcodec.StringCodec;
import io.datarouter.filesystem.raw.queue.DirectoryQueue;
import io.datarouter.model.databean.EmptyDatabean;
import io.datarouter.model.key.EmptyDatabeanKey;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.BlobQueueStorage;
import io.datarouter.storage.node.type.physical.base.BasePhysicalNode;
import io.datarouter.storage.queue.BlobQueueMessage;
import java.util.Map;
import java.util.Optional;

public class DirectoryBlobQueueNode<T>
extends BasePhysicalNode<EmptyDatabeanKey, EmptyDatabean, EmptyDatabean.EmptyDatabeanFielder>
implements BlobQueueStorage.PhysicalBlobQueueStorageNode<T> {
    private final DirectoryQueue directoryQueue;
    private final Codec<T, byte[]> codec;

    public DirectoryBlobQueueNode(DirectoryQueue directoryQueue, NodeParams<EmptyDatabeanKey, EmptyDatabean, EmptyDatabean.EmptyDatabeanFielder> params, Codec<T, byte[]> codec) {
        super(params, null);
        this.directoryQueue = directoryQueue;
        this.codec = codec;
    }

    public int getMaxRawDataSize() {
        return Integer.MAX_VALUE;
    }

    public Codec<T, byte[]> getCodec() {
        return this.codec;
    }

    public void putRaw(byte[] data, Config config) {
        this.directoryQueue.putMessage(data);
    }

    public Optional<BlobQueueMessage<T>> peek(Config config) {
        return this.directoryQueue.peek().map(message -> new BlobQueueMessage(message.getIdUtf8Bytes(), message.content, Map.of(), this.codec));
    }

    public void ack(byte[] handle, Config config) {
        this.directoryQueue.ack(StringCodec.UTF_8.decode(handle));
    }
}

