/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.node.object;

import io.datarouter.filesystem.node.object.DirectoryBlobStorage;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.file.DatabaseBlob;
import io.datarouter.storage.file.DatabaseBlobKey;
import io.datarouter.storage.file.Pathbean;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.BlobStorage;
import io.datarouter.storage.node.type.physical.base.BasePhysicalNode;
import io.datarouter.storage.util.Subpath;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class DirectoryBlobStorageNode
extends BasePhysicalNode<DatabaseBlobKey, DatabaseBlob, DatabaseBlob.DatabaseBlobFielder>
implements BlobStorage.PhysicalBlobStorageNode {
    private final DirectoryBlobStorage directoryBlobStorage;
    private final String bucket;
    private final Subpath rootPath;

    public DirectoryBlobStorageNode(NodeParams<DatabaseBlobKey, DatabaseBlob, DatabaseBlob.DatabaseBlobFielder> params, ClientType<?, ?> clientType, DirectoryBlobStorage directoryBlobStorage, String bucket, Subpath rootPath) {
        super(params, clientType);
        this.directoryBlobStorage = directoryBlobStorage;
        this.bucket = bucket;
        this.rootPath = rootPath;
    }

    public String getBucket() {
        return this.bucket;
    }

    public Subpath getRootPath() {
        return this.rootPath;
    }

    public boolean exists(PathbeanKey key, Config config) {
        return this.directoryBlobStorage.exists(key);
    }

    public Optional<Long> length(PathbeanKey key, Config config) {
        return this.directoryBlobStorage.length(key);
    }

    public byte[] read(PathbeanKey key, Config config) {
        return this.directoryBlobStorage.read(key);
    }

    public byte[] readPartial(PathbeanKey key, long offset, int length, Config config) {
        return this.directoryBlobStorage.read(key, offset, length);
    }

    public Map<PathbeanKey, byte[]> readMulti(List<PathbeanKey> keys, Config config) {
        return Scanner.of(keys).toMap(Function.identity(), this.directoryBlobStorage::read);
    }

    public InputStream readInputStream(PathbeanKey key, Config config) {
        return this.directoryBlobStorage.readInputStream(key);
    }

    public void write(PathbeanKey key, byte[] content, Config config) {
        this.directoryBlobStorage.write(key, content);
    }

    public void writeInputStream(PathbeanKey key, InputStream inputStream, Config config) {
        this.directoryBlobStorage.write(key, inputStream);
    }

    public Scanner<List<Pathbean>> scanPaged(Subpath subpath, Config config) {
        boolean sorted = config.findAllowUnsortedScan().orElse(false) == false;
        return this.directoryBlobStorage.scanPaged(subpath, sorted);
    }

    public Scanner<List<PathbeanKey>> scanKeysPaged(Subpath subpath, Config config) {
        boolean sorted = config.findAllowUnsortedScan().orElse(false) == false;
        return this.directoryBlobStorage.scanKeysPaged(subpath, sorted);
    }

    public void delete(PathbeanKey key, Config config) {
        this.directoryBlobStorage.delete(key);
    }

    public void deleteMulti(List<PathbeanKey> keys, Config config) {
        keys.forEach(this.directoryBlobStorage::delete);
    }

    public void deleteAll(Subpath subpath, Config config) {
        this.directoryBlobStorage.deleteAll(subpath);
    }

    public void vacuum(Config config) {
        throw new UnsupportedOperationException();
    }
}

