/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.web;

import io.datarouter.filesystem.snapshot.block.BlockKey;
import io.datarouter.filesystem.snapshot.block.root.RootBlock;
import io.datarouter.filesystem.snapshot.group.SnapshotGroups;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.types.Param;
import io.datarouter.web.html.j2html.J2HtmlTable;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import io.datarouter.web.requirejs.DatarouterWebRequireJsV2;
import j2html.tags.ContainerTag;
import j2html.tags.specialized.TableTag;
import javax.inject.Inject;

public class DatarouterSnapshotHandler
extends BaseHandler {
    public static final String P_groupId = "groupId";
    public static final String P_snapshotId = "snapshotId";
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private SnapshotGroups groups;

    @BaseHandler.Handler
    public Mav summary(@Param(value="groupId") String groupId, @Param(value="snapshotId") String snapshotId) {
        SnapshotKey snapshotKey = new SnapshotKey(groupId, snapshotId);
        RootBlock rootBlock = this.groups.getGroup(groupId).root(BlockKey.root(snapshotKey));
        return this.pageFactory.startBuilder(this.request).withTitle("Datarouter Filesystem - Snapshot Groups").withRequires(new String[]{DatarouterWebRequireJsV2.SORTTABLE}).withContent(this.buildSummary(rootBlock)).buildMav();
    }

    private ContainerTag<?> buildSummary(RootBlock rootBlock) {
        TableTag table = new J2HtmlTable().withClasses(new String[]{"sortable table table-sm table-striped my-4 border"}).withColumn("Key", row -> row.getKey()).withColumn("Value", row -> row.getValue()).build(rootBlock.toKeyValueStrings().entrySet());
        return table;
    }
}

