/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.group.groupops;

import io.datarouter.bytes.EmptyArray;
import io.datarouter.filesystem.snapshot.block.root.RootBlock;
import io.datarouter.filesystem.snapshot.entry.SnapshotEntry;
import io.datarouter.filesystem.snapshot.group.SnapshotGroup;
import io.datarouter.filesystem.snapshot.group.dto.SnapshotWriteResult;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.filesystem.snapshot.reader.block.DecodingBlockLoader;
import io.datarouter.filesystem.snapshot.reader.block.DecodingBlockLoaderFactory;
import io.datarouter.filesystem.snapshot.storage.block.SnapshotBlockStorage;
import io.datarouter.filesystem.snapshot.storage.file.SnapshotFileStorage;
import io.datarouter.filesystem.snapshot.writer.SnapshotWriter;
import io.datarouter.filesystem.snapshot.writer.SnapshotWriterConfig;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.file.Directory;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.util.UlidTool;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotGroupWriteOps {
    private static final Logger logger = LoggerFactory.getLogger(SnapshotGroupWriteOps.class);
    private final SnapshotGroup group;
    private final String groupId;
    private final DecodingBlockLoaderFactory decodingBlockLoaderFactory;
    private final Directory cacheStorage;
    private final Directory idDirectory;
    private final Map<SnapshotKey, DecodingBlockLoader> decodingBlockLoaderBySnapshotKey;

    public SnapshotGroupWriteOps(SnapshotGroup group, String groupId, DecodingBlockLoaderFactory decodingBlockLoaderFactory, Directory cacheDirectory, Directory idDirectory, Map<SnapshotKey, DecodingBlockLoader> decodingBlockLoaderBySnapshotKey) {
        this.group = group;
        this.groupId = groupId;
        this.decodingBlockLoaderFactory = decodingBlockLoaderFactory;
        this.cacheStorage = cacheDirectory;
        this.idDirectory = idDirectory;
        this.decodingBlockLoaderBySnapshotKey = decodingBlockLoaderBySnapshotKey;
    }

    public SnapshotWriteResult write(SnapshotWriterConfig config, Scanner<List<SnapshotEntry>> entries, ExecutorService exec, Supplier<Boolean> shouldStop) {
        String snapshotId = UlidTool.nextUlid();
        return this.writeWithId(config, entries, snapshotId, exec, shouldStop);
    }

    private SnapshotWriteResult writeWithId(SnapshotWriterConfig config, Scanner<List<SnapshotEntry>> entries, String snapshotId, ExecutorService exec, Supplier<Boolean> shouldStop) {
        SnapshotKey snapshotKey = new SnapshotKey(this.groupId, snapshotId);
        SnapshotFileStorage snapshotFileStorage = this.group.makeSnapshotFileStorage(snapshotKey.snapshotId);
        SnapshotBlockStorage snapshotBlockStorage = this.cacheStorage == null ? null : this.group.makeCacheStorage(snapshotKey.snapshotId);
        Throwable throwable = null;
        Object var10_11 = null;
        try (SnapshotWriter writer = new SnapshotWriter(snapshotKey, snapshotFileStorage, snapshotBlockStorage, config, exec);){
            entries.advanceUntil($ -> (Boolean)shouldStop.get()).forEach(writer::addBatch);
            if (shouldStop.get().booleanValue()) {
                return SnapshotWriteResult.failure(snapshotKey);
            }
            return writer.complete().map(rootBlock -> {
                this.writeIdFile(snapshotKey.snapshotId);
                this.decodingBlockLoaderBySnapshotKey.put(snapshotKey, this.decodingBlockLoaderFactory.create((RootBlock)rootBlock, this.group.makeStorageReader(snapshotKey.snapshotId)));
                return SnapshotWriteResult.success(snapshotKey, rootBlock);
            }).orElseGet(() -> {
                logger.warn("snapshot {} had no entries and was not written", (Object)snapshotKey);
                return SnapshotWriteResult.empty(snapshotKey);
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void writeIdFile(String snapshotId) {
        this.idDirectory.write(PathbeanKey.of((String)snapshotId), EmptyArray.BYTE);
    }
}

