/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.group.groupops;

import io.datarouter.filesystem.snapshot.block.BlockKey;
import io.datarouter.filesystem.snapshot.group.SnapshotGroup;
import io.datarouter.filesystem.snapshot.group.dto.SnapshotKeyAndRoot;
import io.datarouter.filesystem.snapshot.group.groupops.SnapshotGroupFileReadOps;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.filesystem.snapshot.key.SnapshotKeyDecoder;
import io.datarouter.scanner.ParallelScannerContext;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.cached.CachingSupplier;
import io.datarouter.util.collection.ListTool;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

public class SnapshotGroupKeyReadOps {
    private final SnapshotGroup group;
    private final SnapshotGroupFileReadOps groupFileReader;
    private final SnapshotKeyDecoder snapshotKeyDecoder;
    private final Supplier<List<SnapshotKey>> cachedKeys;
    private final boolean cacheOk;

    public SnapshotGroupKeyReadOps(SnapshotGroup group, SnapshotGroupFileReadOps groupFileReader, SnapshotKeyDecoder snapshotKeyDecoder, boolean cacheOk) {
        this.group = group;
        this.groupFileReader = groupFileReader;
        this.snapshotKeyDecoder = snapshotKeyDecoder;
        this.cachedKeys = new CachingSupplier(() -> groupFileReader.scanSnapshotKeysFromStorage().list(), Duration.ofMinutes(1L));
        this.cacheOk = cacheOk;
    }

    public Scanner<SnapshotKey> scanSnapshotKeys() {
        return this.cacheOk ? Scanner.of((Iterable)this.cachedKeys.get()) : this.groupFileReader.scanSnapshotKeysFromStorage();
    }

    public Optional<SnapshotKey> findLastSnapshotKey() {
        return this.cacheOk ? ListTool.findLast(this.cachedKeys.get()) : this.groupFileReader.scanSnapshotKeysFromStorage().findLast();
    }

    public Scanner<SnapshotKey> scanSnapshotKeysOlderThan(Duration duration) {
        Instant endTime = Instant.now().minus(duration);
        return this.scanSnapshotKeys().advanceWhile(key -> this.snapshotKeyDecoder.toInstant((SnapshotKey)key).compareTo(endTime) < 0);
    }

    public Scanner<SnapshotKeyAndRoot> scanSnapshotKeysAndRootBlocks(ExecutorService exec, int numThreads) {
        return this.scanSnapshotKeys().parallel(new ParallelScannerContext(exec, numThreads, false)).map(key -> new SnapshotKeyAndRoot((SnapshotKey)key, this.group.root(BlockKey.root(key))));
    }
}

