/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.group;

import io.datarouter.filesystem.snapshot.block.Block;
import io.datarouter.filesystem.snapshot.block.BlockKey;
import io.datarouter.filesystem.snapshot.block.leaf.LeafBlock;
import io.datarouter.filesystem.snapshot.group.SnapshotGroup;
import io.datarouter.filesystem.snapshot.reader.block.BlockLoader;
import io.datarouter.filesystem.snapshot.reader.block.LeafBlockRangeLoader;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.Require;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;

@Singleton
public class SnapshotGroups
implements BlockLoader {
    private final Map<String, SnapshotGroup> groupById = new ConcurrentHashMap<String, SnapshotGroup>();

    public SnapshotGroup register(SnapshotGroup group) {
        SnapshotGroup existing = this.groupById.putIfAbsent(group.getGroupId(), group);
        Require.isNull((Object)existing, (String)("SnapshotGroup was already registered:" + group.getGroupId()));
        return group;
    }

    @Override
    public Block get(BlockKey blockKey) {
        SnapshotGroup group = this.groupById.get(blockKey.snapshotKey.groupId);
        return group.get(blockKey);
    }

    @Override
    public Scanner<LeafBlock> leafRange(LeafBlockRangeLoader.LeafBlockRange range) {
        SnapshotGroup group = this.groupById.get(range.firstBlockKey.snapshotKey.groupId);
        return group.leafRange(range);
    }

    public Scanner<String> scanIds() {
        return Scanner.of(this.groupById.keySet());
    }

    public SnapshotGroup getGroup(String groupId) {
        return this.groupById.get(groupId);
    }
}

