/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.web;

import io.datarouter.filesystem.snapshot.group.SnapshotGroup;
import io.datarouter.filesystem.snapshot.group.SnapshotGroups;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.filesystem.snapshot.reader.ScanningSnapshotReader;
import io.datarouter.filesystem.snapshot.web.DatarouterSnapshotExecutors;
import io.datarouter.filesystem.snapshot.web.DatarouterSnapshotPaths;
import io.datarouter.filesystem.snapshot.web.SnapshotRecordStringDecoder;
import io.datarouter.util.lang.ReflectionTool;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.types.Param;
import io.datarouter.web.handler.types.optional.OptionalLong;
import io.datarouter.web.html.j2html.J2HtmlTable;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import io.datarouter.web.requirejs.DatarouterWebRequireJsV2;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.TableTag;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import org.apache.http.client.utils.URIBuilder;

public class DatarouterSnapshotEntriesHandler
extends BaseHandler {
    public static final String P_groupId = "groupId";
    public static final String P_snapshotId = "snapshotId";
    public static final String P_offset = "offset";
    public static final String P_limit = "limit";
    @Inject
    private DatarouterSnapshotExecutors.DatarouterSnapshotWebExecutor exec;
    @Inject
    private DatarouterSnapshotPaths snapshotPaths;
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private SnapshotGroups groups;

    @BaseHandler.Handler
    public Mav entries(@Param(value="groupId") String groupId, @Param(value="snapshotId") String snapshotId, @Param(value="offset") OptionalLong optOffset, @Param(value="limit") OptionalLong optLimit) {
        DivTag content;
        SnapshotKey snapshotKey = new SnapshotKey(groupId, snapshotId);
        SnapshotGroup group = this.groups.getGroup(snapshotKey.groupId);
        if (group.getSnapshotEntryDecoderClass() == null) {
            String message = String.format("%s not defined for groupId=%s", SnapshotRecordStringDecoder.class.getSimpleName(), snapshotKey.groupId);
            content = TagCreator.div((String)message);
        } else {
            long offset = (Long)optOffset.orElse((Object)0L);
            long limit = (Long)optLimit.orElse((Object)100L);
            content = this.buildTable(snapshotKey, offset, limit);
        }
        return this.pageFactory.startBuilder(this.request).withTitle("Datarouter Filesystem - Snapshot Entries").withRequires(new String[]{DatarouterWebRequireJsV2.SORTTABLE}).withContent((DomContent)content).buildMav();
    }

    private DomContent buildTable(SnapshotKey snapshotKey, long offset, long limit) {
        SnapshotGroup group = this.groups.getGroup(snapshotKey.groupId);
        ScanningSnapshotReader reader = new ScanningSnapshotReader(snapshotKey, (ExecutorService)((Object)this.exec), 2, this.groups, 1);
        SnapshotRecordStringDecoder decoder = (SnapshotRecordStringDecoder)ReflectionTool.create(group.getSnapshotEntryDecoderClass());
        List rows = reader.scan(0).skip(offset).limit(limit).map(decoder::decode).list();
        TableTag table = new J2HtmlTable().withClasses(new String[]{"sortable table table-sm table-striped my-4 border"}).withColumn("id", row -> row.id).withColumn(decoder.keyName(), row -> row.key).withColumn(decoder.valueName(), row -> {
            if (row.value == null) {
                return "";
            }
            if (row.value.length() < 64) {
                return row.value;
            }
            return row.value.subSequence(0, 64) + "...";
        }).withHtmlColumn("details", row -> {
            String href = new URIBuilder().setPath(String.valueOf(this.request.getContextPath()) + this.snapshotPaths.datarouter.snapshot.individual.entry.toSlashedString()).addParameter(P_groupId, snapshotKey.groupId).addParameter(P_snapshotId, snapshotKey.snapshotId).addParameter("id", Long.toString(row.id)).toString();
            return TagCreator.td((DomContent[])new DomContent[]{TagCreator.a((String)"view").withHref(href)});
        }).build((Collection)rows);
        return table;
    }
}

