/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.reader.block;

import io.datarouter.filesystem.snapshot.block.BlockKey;
import io.datarouter.filesystem.snapshot.block.branch.BranchBlock;
import io.datarouter.filesystem.snapshot.block.leaf.LeafBlock;
import io.datarouter.filesystem.snapshot.block.root.RootBlock;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.filesystem.snapshot.reader.block.BlockLoader;
import io.datarouter.filesystem.snapshot.reader.block.LeafBlockRangeLoader;
import io.datarouter.scanner.ParallelScannerContext;
import io.datarouter.scanner.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;

public class ScanningBlockReader {
    private final SnapshotKey snapshotKey;
    private final ExecutorService exec;
    private final int numThreads;
    private final int numBlocks;
    private final BlockLoader blockLoader;
    private final RootBlock rootBlock;

    public ScanningBlockReader(SnapshotKey snapshotKey, ExecutorService exec, int numThreads, int numBlocks, BlockLoader blockLoader) {
        this.snapshotKey = snapshotKey;
        this.exec = exec;
        this.numThreads = numThreads;
        this.numBlocks = numBlocks;
        this.blockLoader = blockLoader;
        this.rootBlock = blockLoader.root(BlockKey.root(snapshotKey));
    }

    public Scanner<LeafBlock> scanLeafBlocks(long fromRecordIdInclusive) {
        return ((Scanner)this.scanLeafBlockKeys(fromRecordIdInclusive).apply(leafBlockKeys -> LeafBlockRangeLoader.splitByFileAndBatch((Scanner<BlockKey>)leafBlockKeys, this.numBlocks))).parallel(new ParallelScannerContext(this.exec, this.numThreads, false)).map(this.blockLoader::leafRange).concat(Function.identity());
    }

    private Scanner<BlockKey> scanLeafBlockKeys(long fromRecordIdInclusive) {
        BlockKey topBranchBlockKey = this.rootBlock.rootBranchBlockKey(this.snapshotKey);
        BranchBlock topBranchBlock = this.blockLoader.branch(topBranchBlockKey);
        return this.scanDescendantBranchBlocks(topBranchBlock, fromRecordIdInclusive).include(branchBlock -> branchBlock.level() == 0).concat(branchBlock -> Scanner.iterate((Object)0, i -> i + 1).limit((long)branchBlock.numRecords()).include(index -> branchBlock.recordId((int)index) >= fromRecordIdInclusive).map(branchBlock::childBlock).map(leafBlockId -> branchBlock.leafBlockKey(this.snapshotKey, (int)leafBlockId)));
    }

    private Scanner<BranchBlock> scanDescendantBranchBlocks(BranchBlock branchBlock, long fromRecordIdInclusive) {
        if (branchBlock.level() == 0) {
            return Scanner.of((Object)branchBlock);
        }
        return branchBlock.childBlockIds().map(childBlockId -> branchBlock.childBranchBlockKey(this.snapshotKey, (int)childBlockId)).parallel(new ParallelScannerContext(this.exec, this.numThreads, false)).map(this.blockLoader::branch).include(childBranchBlock -> childBranchBlock.lastRecordId() >= fromRecordIdInclusive).concat(childBranchBlock -> this.scanDescendantBranchBlocks((BranchBlock)childBranchBlock, fromRecordIdInclusive));
    }
}

