/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.reader.block;

import io.datarouter.filesystem.snapshot.block.leaf.LeafBlock;
import io.datarouter.filesystem.snapshot.block.root.RootBlock;
import io.datarouter.filesystem.snapshot.block.value.ValueBlock;
import io.datarouter.filesystem.snapshot.reader.record.SnapshotRecord;
import io.datarouter.scanner.Scanner;
import java.util.List;
import java.util.stream.IntStream;

public class LeafBlockWithValueBlocks {
    private final RootBlock rootBlock;
    private final LeafBlock leafBlock;
    private final int[] firstValueBlockIds;
    private final List<List<ValueBlock>> valueBlocks;

    public LeafBlockWithValueBlocks(RootBlock rootBlock, LeafBlock leafBlock, List<List<ValueBlock>> valueBlocks) {
        this.rootBlock = rootBlock;
        this.leafBlock = leafBlock;
        this.firstValueBlockIds = IntStream.range(0, rootBlock.numColumns()).map(leafBlock::firstValueBlockId).toArray();
        this.valueBlocks = valueBlocks;
    }

    public ValueBlock getValueBlock(int column, int index) {
        return this.valueBlocks.get(column).get(index - this.firstValueBlockIds[column]);
    }

    public Scanner<SnapshotRecord> scan(int fromRecordIdInclusive) {
        return Scanner.iterate((Object)0, recordIndex -> recordIndex + 1).limit((long)this.leafBlock.numRecords()).include(recordIndex -> this.leafBlock.recordId((int)recordIndex) >= (long)fromRecordIdInclusive).map(recordIndex -> {
            long recordId = this.leafBlock.firstRecordId() + (long)recordIndex.intValue();
            byte[] key = this.leafBlock.blockKey((int)recordIndex).toArray();
            byte[] value = this.leafBlock.blockValue((int)recordIndex).toArray();
            byte[][] columnValues = new byte[this.rootBlock.numColumns()][];
            int column = 0;
            while (column < this.rootBlock.numColumns()) {
                int valueBlockOffset = this.leafBlock.valueBlockOffsetForKey(column, (int)recordIndex);
                int valueBlockId = this.leafBlock.firstValueBlockId(column) + valueBlockOffset;
                ValueBlock valueBlock = this.getValueBlock(column, valueBlockId);
                int valueIndex = this.leafBlock.valueIndex(column, valueBlockOffset, (int)recordIndex);
                columnValues[column] = valueBlock.value(valueIndex).toArray();
                ++column;
            }
            return new SnapshotRecord(recordId, key, value, columnValues);
        });
    }
}

