/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.reader.block;

import io.datarouter.bytes.Bytes;
import io.datarouter.filesystem.snapshot.block.BlockKey;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.Require;
import io.datarouter.util.collection.ListTool;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;

public class LeafBlockRangeLoader {
    public static Scanner<LeafBlockRange> splitByFileAndBatch(Scanner<BlockKey> leafBlockKeys, int blocksPerBatch) {
        return leafBlockKeys.splitBy(key -> key.fileId).concat(keysInFile -> keysInFile.batch(blocksPerBatch).map(LeafBlockRange::new)).concat(Scanner::of);
    }

    public static class LeafBlockRange {
        public final List<BlockKey> blockKeys;
        public final BlockKey firstBlockKey;
        public final BlockKey lastBlockKey;
        public final SnapshotKey snapshotKey;
        public final int fileId;
        public final int fileFrom;
        public final int fileTo;

        public LeafBlockRange(List<BlockKey> blockKeys) {
            this.blockKeys = blockKeys;
            this.firstBlockKey = blockKeys.get(0);
            this.lastBlockKey = (BlockKey)ListTool.getLast(blockKeys);
            this.snapshotKey = this.firstBlockKey.snapshotKey;
            this.fileId = this.firstBlockKey.fileId;
            Require.equals((Object)this.firstBlockKey.fileId, (Object)this.lastBlockKey.fileId);
            this.fileFrom = this.firstBlockKey.offset;
            this.fileTo = this.lastBlockKey.offset + this.lastBlockKey.length;
        }

        public BlockKey rangeBlockKey() {
            int blockId = -1;
            int length = this.fileTo - this.fileFrom;
            return BlockKey.leaf(this.firstBlockKey.snapshotKey, blockId, this.fileId, this.fileFrom, length);
        }

        public Scanner<Bytes> parse(byte[] multiBlockBytes) {
            return Scanner.of(this.blockKeys).map(blockKey -> {
                int from = blockKey.offset - this.fileFrom;
                return new Bytes(multiBlockBytes, from, blockKey.length);
            });
        }

        public String toString() {
            LinkedHashMap<String, Integer> kvs = new LinkedHashMap<String, Integer>();
            kvs.put("fileId", this.fileId);
            kvs.put("numBlocks", this.blockKeys.size());
            kvs.put("firstBlockId", this.firstBlockKey.blockId);
            kvs.put("lastBlockId", this.lastBlockKey.blockId);
            kvs.put("fileFrom", this.fileFrom);
            kvs.put("fileTo", this.fileTo);
            return kvs.entrySet().stream().map(kv -> String.format("%s=%s", kv.getKey(), kv.getValue())).collect(Collectors.joining(", "));
        }
    }
}

