/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.reader;

import io.datarouter.filesystem.snapshot.block.BlockKey;
import io.datarouter.filesystem.snapshot.block.leaf.LeafBlock;
import io.datarouter.filesystem.snapshot.block.root.RootBlock;
import io.datarouter.filesystem.snapshot.block.value.ValueBlock;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.filesystem.snapshot.reader.SnapshotKeyReader;
import io.datarouter.filesystem.snapshot.reader.block.BlockLoader;
import io.datarouter.filesystem.snapshot.reader.block.LeafBlockWithValueBlocks;
import io.datarouter.filesystem.snapshot.reader.block.ScanningBlockReader;
import io.datarouter.filesystem.snapshot.reader.record.SnapshotLeafRecord;
import io.datarouter.filesystem.snapshot.reader.record.SnapshotLeafSearchResult;
import io.datarouter.filesystem.snapshot.reader.record.SnapshotRecord;
import io.datarouter.scanner.Scanner;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;

public class ScanningSnapshotReader {
    private final SnapshotKey snapshotKey;
    private final BlockLoader blockLoader;
    private final RootBlock rootBlock;
    private final ScanningBlockReader scanningBlockReader;

    public ScanningSnapshotReader(SnapshotKey snapshotKey, ExecutorService exec, int numThreads, BlockLoader blockLoader, int numBlocks) {
        this.snapshotKey = snapshotKey;
        this.blockLoader = blockLoader;
        this.rootBlock = blockLoader.root(BlockKey.root(snapshotKey));
        this.scanningBlockReader = new ScanningBlockReader(snapshotKey, exec, numThreads, numBlocks, blockLoader);
    }

    public Scanner<SnapshotLeafRecord> scanLeafRecords(long fromRecordIdInclusive) {
        return this.scanningBlockReader.scanLeafBlocks(fromRecordIdInclusive).concat(LeafBlock::leafRecords).include(leafRecord -> leafRecord.id >= fromRecordIdInclusive);
    }

    public Scanner<SnapshotLeafRecord> scanLeafRecords(byte[] startKey, boolean inclusive) {
        SnapshotKeyReader keyReader = new SnapshotKeyReader(this.snapshotKey, this.blockLoader);
        LeafBlock leafBlock = keyReader.leafBlock(startKey);
        SnapshotLeafSearchResult searchResult = leafBlock.search(startKey);
        long fromRecordIdInclusive = searchResult.recordId(inclusive);
        return this.scanLeafRecords(fromRecordIdInclusive);
    }

    public Scanner<byte[]> scanKeys() {
        return this.scanningBlockReader.scanLeafBlocks(0L).concat(LeafBlock::keyCopies);
    }

    public Scanner<byte[]> scanValues() {
        return this.scanningBlockReader.scanLeafBlocks(0L).concat(LeafBlock::valueCopies);
    }

    public Scanner<byte[]> scanColumnValues(int column) {
        AtomicInteger lastValueBlockId = new AtomicInteger(-1);
        return this.scanningBlockReader.scanLeafBlocks(0L).concat(leafBlock -> leafBlock.valueBlockIds(column).include(valueBlockId -> lastValueBlockId.compareAndSet(valueBlockId - 1, (int)valueBlockId)).map(valueBlockId -> leafBlock.valueBlockKey(this.snapshotKey, column, (int)valueBlockId)).map(this.blockLoader::value).concat(ValueBlock::valueCopies));
    }

    public Scanner<SnapshotRecord> scan(int fromRecordIdInclusive) {
        return this.scanningBlockReader.scanLeafBlocks(fromRecordIdInclusive).map(leafBlock -> (LeafBlockWithValueBlocks)Scanner.iterate((Object)0, column -> column + 1).limit((long)this.rootBlock.numColumns()).map(column -> leafBlock.valueBlockIds((int)column).map(valueBlockId -> {
            BlockKey valueBlockKey = leafBlock.valueBlockKey(this.snapshotKey, (int)column, (int)valueBlockId);
            return this.blockLoader.value(valueBlockKey);
        }).list()).listTo(valueBlocks -> new LeafBlockWithValueBlocks(this.rootBlock, (LeafBlock)leafBlock, (List<List<ValueBlock>>)valueBlocks))).concat(leafBlockWithValueBlocks -> leafBlockWithValueBlocks.scan(fromRecordIdInclusive));
    }
}

