/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.path;

import io.datarouter.filesystem.snapshot.path.SnapshotPaths;
import io.datarouter.filesystem.snapshot.storage.block.CacheBlockKey;
import io.datarouter.filesystem.snapshot.storage.file.FileKey;
import io.datarouter.util.string.StringTool;

public class SnapshotPathsV1
implements SnapshotPaths {
    public static final String FORMAT = "pathsV1";
    private static final boolean DIRECTORY_100 = true;
    private static final int[] DIGIT_POSITIONS;

    static {
        int[] nArray = new int[10];
        nArray[0] = 13;
        nArray[1] = 12;
        nArray[2] = 10;
        nArray[3] = 9;
        nArray[4] = 7;
        nArray[5] = 6;
        nArray[6] = 4;
        nArray[7] = 3;
        nArray[8] = 1;
        DIGIT_POSITIONS = nArray;
    }

    @Override
    public String format() {
        return FORMAT;
    }

    @Override
    public String branchFile(FileKey fileKey) {
        String levelString = StringTool.pad((String)Integer.toString(fileKey.level), (char)'0', (int)3);
        return "branch/" + levelString + "/" + SnapshotPathsV1.makeFilename(fileKey.fileId);
    }

    @Override
    public String leafFile(FileKey fileKey) {
        return "leaf/" + SnapshotPathsV1.makeFilename(fileKey.fileId);
    }

    @Override
    public String valueFile(FileKey fileKey) {
        String columnString = StringTool.pad((String)Integer.toString(fileKey.column), (char)'0', (int)3);
        return "value/" + columnString + "/" + SnapshotPathsV1.makeFilename(fileKey.fileId);
    }

    @Override
    public String branchBlock(CacheBlockKey cacheBlockKey) {
        return String.join((CharSequence)"/", "branch", Integer.toString(cacheBlockKey.level), Integer.toString(cacheBlockKey.blockId));
    }

    @Override
    public String leafBlock(CacheBlockKey cacheBlockKey) {
        return String.join((CharSequence)"/", "leaf", Integer.toString(cacheBlockKey.blockId));
    }

    @Override
    public String valueBlock(CacheBlockKey cacheBlockKey) {
        return String.join((CharSequence)"/", "value", Integer.toString(cacheBlockKey.column), Integer.toString(cacheBlockKey.blockId));
    }

    private static String makeFilename(int index) {
        byte[] name = new byte[]{48, 48, 47, 48, 48, 47, 48, 48, 47, 48, 48, 47, 48, 48};
        int remaining = index;
        int i = 0;
        while (remaining > 0 && i < DIGIT_POSITIONS.length) {
            int ascii = 48 + remaining % 10;
            name[SnapshotPathsV1.DIGIT_POSITIONS[i]] = (byte)ascii;
            remaining /= 10;
            ++i;
        }
        return new String(name);
    }
}

