/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.group.groupops;

import io.datarouter.filesystem.snapshot.group.SnapshotGroup;
import io.datarouter.filesystem.snapshot.group.groupops.SnapshotGroupFileReadOps;
import io.datarouter.filesystem.snapshot.group.groupops.SnapshotGroupKeyReadOps;
import io.datarouter.filesystem.snapshot.group.vacuum.SnapshotVacuumConfig;
import io.datarouter.filesystem.snapshot.group.vacuum.SnapshotVacuumPlanner;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.filesystem.snapshot.key.SnapshotKeyDecoder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.file.Directory;
import io.datarouter.storage.file.PathbeanKey;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotGroupVacuumOps {
    private static final Logger logger = LoggerFactory.getLogger(SnapshotGroupVacuumOps.class);
    private final SnapshotGroup group;
    private final String groupId;
    private final Directory fileDirectory;
    private final SnapshotKeyDecoder snapshotKeyDecoder;
    private final SnapshotVacuumConfig vacuumConfig;
    private final SnapshotGroupFileReadOps groupFileReader;
    private final SnapshotGroupKeyReadOps groupReader;

    public SnapshotGroupVacuumOps(SnapshotGroup group, String groupId, Directory fileDirectory, SnapshotKeyDecoder snapshotKeyDecoder, SnapshotVacuumConfig vacuumConfig, SnapshotGroupFileReadOps groupFileReader, SnapshotGroupKeyReadOps groupReader) {
        this.group = group;
        this.groupId = groupId;
        this.fileDirectory = fileDirectory;
        this.snapshotKeyDecoder = snapshotKeyDecoder;
        this.vacuumConfig = vacuumConfig;
        this.groupFileReader = groupFileReader;
        this.groupReader = groupReader;
    }

    public void vacuum(ExecutorService exec, int numThreads) {
        List keys = this.groupReader.scanSnapshotKeys().list();
        SnapshotVacuumPlanner.SnapshotVacuumPlan plan = new SnapshotVacuumPlanner(this.vacuumConfig, this.snapshotKeyDecoder, keys).plan();
        logger.warn("Starting vacuum id={}, group={}, {}/{} snapshots", new Object[]{plan.id, this.groupId, plan.items.size(), keys.size()});
        Scanner.of(plan.items).each(result -> logger.warn("vacuum id={}, group={} deleting {} because {}", new Object[]{snapshotVacuumPlan.id, this.groupId, result.snapshotKey.snapshotId, result.reason})).forEach(result -> this.group.deleteOps().deleteSnapshot(result.snapshotKey, exec, numThreads));
        logger.warn("Finished vacuum id={}, group={}, {}/{} snapshots", new Object[]{plan.id, this.groupId, plan.items.size(), keys.size()});
    }

    public void vacuumOrphanedFilesOlderThan(Duration duration) {
        Set cachedIds = (Set)this.groupReader.scanSnapshotKeys().map(key -> key.snapshotId).collect(HashSet::new);
        this.groupFileReader.scanSnapshotFilesFromStorage().advanceWhile(pathbeanKey -> {
            SnapshotKey snapshotKey = this.getSnapshotKeyForFile((PathbeanKey)pathbeanKey);
            return this.snapshotKeyDecoder.isOlderThan(snapshotKey, duration);
        }).exclude(pathbeanKey -> cachedIds.contains(this.getSnapshotKeyForFile((PathbeanKey)pathbeanKey).snapshotId)).forEach(arg_0 -> ((Directory)this.fileDirectory).delete(arg_0));
    }

    private SnapshotKey getSnapshotKeyForFile(PathbeanKey pathbeanKey) {
        return new SnapshotKey(this.groupId, (String)pathbeanKey.getPathSegments().get(0));
    }
}

