/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.combine;

import io.datarouter.filesystem.snapshot.combine.SnapshotCombineTool;
import io.datarouter.filesystem.snapshot.entry.SnapshotEntry;
import io.datarouter.filesystem.snapshot.group.SnapshotGroup;
import io.datarouter.filesystem.snapshot.group.dto.SnapshotKeyAndNumRecords;
import io.datarouter.filesystem.snapshot.group.dto.SnapshotWriteResult;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.filesystem.snapshot.reader.ScanningSnapshotReader;
import io.datarouter.filesystem.snapshot.reader.record.SnapshotLeafRecord;
import io.datarouter.filesystem.snapshot.writer.SnapshotWriterConfig;
import io.datarouter.scanner.Scanner;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotCombiner {
    private static final Logger logger = LoggerFactory.getLogger(SnapshotCombiner.class);
    private final Supplier<Boolean> shouldStop;
    private final SnapshotGroup group;
    private final ExecutorService readExec;
    private final ExecutorService writeExec;
    private final SnapshotWriterConfig writerConfig;
    private final int scanNumBlocks;
    private final int targetNumSnapshots;
    private final int maxNewSnapshotsPerIteration;

    public SnapshotCombiner(Supplier<Boolean> shouldStop, SnapshotGroup group, ExecutorService readExec, ExecutorService writeExec, SnapshotWriterConfig writerConfig, int scanNumBlocks, int targetNumSnapshots, int maxNewSnapshotsPerIteration) {
        this.shouldStop = shouldStop;
        this.group = group;
        this.readExec = readExec;
        this.writeExec = writeExec;
        this.writerConfig = writerConfig;
        this.scanNumBlocks = scanNumBlocks;
        this.targetNumSnapshots = targetNumSnapshots;
        this.maxNewSnapshotsPerIteration = maxNewSnapshotsPerIteration;
    }

    public void combine() {
        while (this.tryCombineSmallestN(this.targetNumSnapshots, this.maxNewSnapshotsPerIteration)) {
        }
    }

    private boolean tryCombineSmallestN(int targetNumSnapshots, long maxNewSnapshots) {
        return ((Scanner)this.group.keyReadOps(false).scanSnapshotKeysAndRootBlocks(this.readExec, 10).map(SnapshotKeyAndNumRecords::new).listTo(dtos -> SnapshotCombineTool.scanSmallestGroups(dtos, targetNumSnapshots, 10))).map(batch -> Scanner.of((Iterable)batch).map(dto -> dto.key).list()).advanceUntil($ -> this.shouldStop.get()).each(keys -> this.combineSnapshots((List<SnapshotKey>)keys)).each(keys -> logger.warn("combined {}, {}", (Object)keys.size(), keys)).limit(maxNewSnapshots).hasAny();
    }

    private void combineSnapshots(List<SnapshotKey> keys) {
        Scanner.of(keys).map(key -> new ScanningSnapshotReader((SnapshotKey)key, this.readExec, 10, this.group, this.scanNumBlocks)).collate(reader -> reader.scanLeafRecords(0L), SnapshotLeafRecord.KEY_COMPARATOR).map(SnapshotLeafRecord::entry).batch(10000).then(this::writeSnapshot);
        keys.forEach(key -> this.group.deleteOps().deleteSnapshot((SnapshotKey)key, this.writeExec, 10));
    }

    private void writeSnapshot(Scanner<List<SnapshotEntry>> entryBatches) {
        entryBatches.then(batches -> {
            SnapshotWriteResult snapshotWriteResult = this.group.writeOps().write(this.writerConfig, (Scanner<List<SnapshotEntry>>)batches, this.writeExec, this.shouldStop);
        });
    }
}

