/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.block.leaf;

import io.datarouter.bytes.ByteReader;
import io.datarouter.bytes.Bytes;
import io.datarouter.bytes.codec.intcodec.RawIntCodec;
import io.datarouter.filesystem.snapshot.block.BlockKey;
import io.datarouter.filesystem.snapshot.block.BlockSizeCalculator;
import io.datarouter.filesystem.snapshot.block.leaf.LeafBlock;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.scanner.Scanner;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class LeafBlockV1
implements LeafBlock {
    public static final String FORMAT = "keyV1";
    private static final RawIntCodec RAW_INT_CODEC = RawIntCodec.INSTANCE;
    private static final int HEAP_SIZE_OVERHEAD = new BlockSizeCalculator().addObjectHeaders(1).addArrays(1).addLongs(1).addInts(7).calculate();
    private final byte[] bytes;
    private final long firstRecordId;
    private final int numRecords;
    private final int numColumns;
    private final int keyEndingSectionOffset;
    private final int keySectionOffset;
    private final int valueEndingSectionOffset;
    private final int valueSectionOffset;
    private final int[] firstValueBlockId;
    private final int[] valueFileIdsSectionOffset;
    private final int[] valueBlockEndingsSectionOffset;
    private final int[] firstValueIndex;
    private final int[] numValueBlockOffsets;
    private final int[] valueBlockOffsetSectionOffset;

    public LeafBlockV1(byte[] bytes) {
        this.bytes = bytes;
        ByteReader reader = new ByteReader(bytes);
        this.firstRecordId = reader.varLong();
        this.numRecords = reader.varInt();
        this.numColumns = reader.varInt();
        this.keyEndingSectionOffset = reader.position();
        reader.skipInts(this.numRecords);
        this.keySectionOffset = reader.position();
        reader.skip(this.keyEnding(this.numRecords - 1));
        this.valueEndingSectionOffset = reader.position();
        reader.skipInts(this.numRecords);
        this.valueSectionOffset = reader.position();
        reader.skip(this.valueEnding(this.numRecords - 1));
        this.firstValueBlockId = new int[this.numColumns];
        this.valueFileIdsSectionOffset = new int[this.numColumns];
        this.valueBlockEndingsSectionOffset = new int[this.numColumns];
        this.firstValueIndex = new int[this.numColumns];
        this.numValueBlockOffsets = new int[this.numColumns];
        this.valueBlockOffsetSectionOffset = new int[this.numColumns];
        int column = 0;
        while (column < this.numColumns) {
            this.firstValueBlockId[column] = reader.varInt();
            int numFileIds = reader.varInt();
            this.valueFileIdsSectionOffset[column] = reader.position();
            reader.skipInts(numFileIds);
            int numValueBlockEndings = reader.varInt();
            this.valueBlockEndingsSectionOffset[column] = reader.position();
            reader.skipInts(numValueBlockEndings);
            this.firstValueIndex[column] = reader.varInt();
            this.numValueBlockOffsets[column] = reader.varInt();
            this.valueBlockOffsetSectionOffset[column] = reader.position();
            reader.skipInts(this.numValueBlockOffsets[column]);
            ++column;
        }
        reader.assertFinished();
    }

    public String toString() {
        return "LeafBlockV1 [numKeys=" + this.numRecords + ", keyOffsetSectionOffset=" + this.keyEndingSectionOffset + ", keySectionOffset=" + this.keySectionOffset + "]";
    }

    @Override
    public int heapSize() {
        return HEAP_SIZE_OVERHEAD + BlockSizeCalculator.pad(this.bytes.length);
    }

    @Override
    public long recordId(int index) {
        return this.firstRecordId + (long)index;
    }

    @Override
    public int numRecords() {
        return this.numRecords;
    }

    @Override
    public Bytes blockKey(int index) {
        int start = index == 0 ? 0 : this.keyEnding(index - 1);
        int end = this.keyEnding(index);
        int length = end - start;
        return new Bytes(this.bytes, this.keySectionOffset + start, length);
    }

    @Override
    public Bytes blockValue(int index) {
        int start = index == 0 ? 0 : this.valueEnding(index - 1);
        int end = this.valueEnding(index);
        int length = end - start;
        return new Bytes(this.bytes, this.valueSectionOffset + start, length);
    }

    @Override
    public int firstValueBlockId(int column) {
        return this.firstValueBlockId[column];
    }

    @Override
    public int numValueBlocks(int column) {
        return this.numValueBlockOffsets[column];
    }

    private int fileId(int column, int valueBlockId) {
        int valueBlockIndex = valueBlockId - this.firstValueBlockId[column] + 1;
        int cursor = this.valueFileIdsSectionOffset[column] + 4 * valueBlockIndex;
        return RAW_INT_CODEC.decode(this.bytes, cursor);
    }

    @Override
    public int valueBlockEnding(int column, int valueBlockId) {
        int valueBlockIndex = valueBlockId - this.firstValueBlockId[column] + 1;
        int cursor = this.valueBlockEndingsSectionOffset[column] + 4 * valueBlockIndex;
        return RAW_INT_CODEC.decode(this.bytes, cursor);
    }

    @Override
    public BlockKey valueBlockKey(SnapshotKey snapshotKey, int column, int valueBlockId) {
        int fileId = this.fileId(column, valueBlockId);
        int start = this.isFirstBlockInFile(column, valueBlockId) ? 0 : this.valueBlockEnding(column, valueBlockId - 1);
        int end = this.valueBlockEnding(column, valueBlockId);
        int length = end - start;
        return BlockKey.value(snapshotKey, column, valueBlockId, fileId, start, length);
    }

    private boolean isFirstBlockInFile(int column, int valueBlockId) {
        int fileId;
        if (valueBlockId == 0) {
            return true;
        }
        int previousFileId = this.fileId(column, valueBlockId - 1);
        return previousFileId != (fileId = this.fileId(column, valueBlockId));
    }

    @Override
    public int firstValueIndex(int column) {
        return this.firstValueIndex[column];
    }

    @Override
    public int valueBlockOffset(int column, int valueBlockOffsetIndex) {
        int bytesOffset = this.valueBlockOffsetSectionOffset[column] + 4 * valueBlockOffsetIndex;
        return RAW_INT_CODEC.decode(this.bytes, bytesOffset);
    }

    private int keyEnding(int index) {
        int endingOffset = 4 * index;
        return RAW_INT_CODEC.decode(this.bytes, this.keyEndingSectionOffset + endingOffset);
    }

    private int valueEnding(int index) {
        int endingOffset = 4 * index;
        return RAW_INT_CODEC.decode(this.bytes, this.valueEndingSectionOffset + endingOffset);
    }

    public String toDetailedString() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("  numRecords" + this.numRecords);
        lines.add("  keyEndings" + (String)Scanner.iterate((Object)0, i -> i + 1).limit((long)this.numRecords).map(this::keyEnding).map(Object::toString).collect(Collectors.joining(",", "[", "]")));
        lines.add("valueEndings" + (String)Scanner.iterate((Object)0, i -> i + 1).limit((long)this.numRecords).map(this::valueEnding).map(Object::toString).collect(Collectors.joining(",", "[", "]")));
        return "\n" + lines.stream().map(Object::toString).collect(Collectors.joining("\n"));
    }
}

