/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.block.branch;

import io.datarouter.bytes.ByteWriter;
import io.datarouter.bytes.PagedObjectArray;
import io.datarouter.bytes.codec.intcodec.RawIntCodec;
import io.datarouter.bytes.codec.longcodec.RawLongCodec;
import io.datarouter.filesystem.snapshot.encode.BranchBlockEncoder;
import io.datarouter.filesystem.snapshot.encode.EncodedBlock;
import io.datarouter.filesystem.snapshot.entry.SnapshotEntry;
import io.datarouter.filesystem.snapshot.writer.BlockQueue;
import java.util.Iterator;

public class BranchBlockV1Encoder
implements BranchBlockEncoder {
    private static final RawIntCodec RAW_INT_CODEC = RawIntCodec.INSTANCE;
    private static final RawLongCodec RAW_LONG_CODEC = RawLongCodec.INSTANCE;
    private int blockId;
    private int level;
    private Integer firstChildBlockId;
    private int numRecords;
    private int numBytes;
    private final PagedObjectArray<Long> recordIds;
    private final PagedObjectArray<byte[]> keys;

    public BranchBlockV1Encoder(int level) {
        this.level = level;
        this.numRecords = 0;
        this.numBytes = 0;
        this.recordIds = new PagedObjectArray(256);
        this.keys = new PagedObjectArray(256);
    }

    @Override
    public String format() {
        return "branchV1";
    }

    @Override
    public void add(int blockId, long recordId, SnapshotEntry entry, int childBlockId) {
        this.blockId = blockId;
        if (this.firstChildBlockId == null) {
            this.firstChildBlockId = childBlockId;
        }
        ++this.numRecords;
        byte[] key = entry.key();
        this.numBytes += key.length;
        this.recordIds.add((Object)recordId);
        this.keys.add((Object)key);
    }

    @Override
    public int numRecords() {
        return this.keys.size();
    }

    @Override
    public int numBytes() {
        return this.numBytes;
    }

    @Override
    public EncodedBlock encode(BlockQueue.FileIdsAndEndings fileIdsAndEndings) {
        ByteWriter headerWriter = new ByteWriter(20);
        headerWriter.varInt(this.level);
        headerWriter.varInt(this.firstChildBlockId.intValue());
        headerWriter.varInt(this.numRecords);
        byte[] header = headerWriter.concat();
        byte[] recordIdsChunk = new byte[this.numRecords * 8];
        int recordIdsCursor = 0;
        Iterator iterator = this.recordIds.iterator();
        while (iterator.hasNext()) {
            long recordId = (Long)iterator.next();
            RAW_LONG_CODEC.encode(recordId, recordIdsChunk, recordIdsCursor);
            recordIdsCursor += 8;
        }
        byte[] keyEndingsChunk = new byte[this.numRecords * 4];
        int keyEnding = 0;
        int keyEndingsCursor = 0;
        for (byte[] key : this.keys) {
            int keyLength = key.length;
            RAW_INT_CODEC.encode(keyEnding += keyLength, keyEndingsChunk, keyEndingsCursor);
            keyEndingsCursor += 4;
        }
        byte[] keysChunk = new byte[this.numBytes];
        int keysCursor = 0;
        for (byte[] key : this.keys) {
            int keyLength = key.length;
            System.arraycopy(key, 0, keysChunk, keysCursor, keyLength);
            keysCursor += keyLength;
        }
        byte[] fileIdsChunk = new byte[fileIdsAndEndings.fileIds.length * 4];
        int fileIdsCursor = 0;
        int[] nArray = fileIdsAndEndings.fileIds;
        int n = fileIdsAndEndings.fileIds.length;
        int n2 = 0;
        while (n2 < n) {
            int fileId = nArray[n2];
            RAW_INT_CODEC.encode(fileId, fileIdsChunk, fileIdsCursor);
            fileIdsCursor += 4;
            ++n2;
        }
        byte[] fileEndingsChunk = new byte[fileIdsAndEndings.endings.length * 4];
        int fileEndingsCursor = 0;
        int[] nArray2 = fileIdsAndEndings.endings;
        int n3 = fileIdsAndEndings.endings.length;
        int n4 = 0;
        while (n4 < n3) {
            int fileEnding = nArray2[n4];
            RAW_INT_CODEC.encode(fileEnding, fileEndingsChunk, fileEndingsCursor);
            fileEndingsCursor += 4;
            ++n4;
        }
        byte[][] chunks = new byte[][]{header, recordIdsChunk, keyEndingsChunk, keysChunk, fileIdsChunk, fileEndingsChunk};
        return new EncodedBlock(chunks);
    }

    @Override
    public int level() {
        return this.level;
    }

    @Override
    public int blockId() {
        return this.blockId;
    }

    @Override
    public int firstChildBlockId() {
        return this.firstChildBlockId;
    }
}

