/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.client;

import io.datarouter.filesystem.client.FilesystemClientType;
import io.datarouter.filesystem.client.FilesystemNodeFactory;
import io.datarouter.filesystem.client.FilesystemOptions;
import io.datarouter.filesystem.node.object.DirectoryBlobStorage;
import io.datarouter.filesystem.node.object.DirectoryBlobStorageNode;
import io.datarouter.filesystem.node.queue.DirectoryGroupQueueNode;
import io.datarouter.filesystem.node.queue.DirectoryQueueNode;
import io.datarouter.filesystem.raw.DirectoryManager;
import io.datarouter.filesystem.raw.queue.DirectoryQueue;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.entity.Entity;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.imp.BaseClientNodeFactory;
import io.datarouter.storage.client.imp.BlobClientNodeFactory;
import io.datarouter.storage.client.imp.QueueClientNodeFactory;
import io.datarouter.storage.client.imp.WrappedNodeFactory;
import io.datarouter.storage.file.Pathbean;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.adapter.counter.physical.PhysicalGroupQueueStorageCounterAdapter;
import io.datarouter.storage.node.adapter.counter.physical.PhysicalQueueStorageCounterAdapter;
import io.datarouter.storage.node.adapter.sanitization.physical.PhysicalGroupQueueStorageSanitizationAdapter;
import io.datarouter.storage.node.adapter.sanitization.physical.PhysicalQueueStorageSanitizationAdapter;
import io.datarouter.storage.node.adapter.trace.physical.PhysicalGroupQueueStorageTraceAdapter;
import io.datarouter.storage.node.adapter.trace.physical.PhysicalQueueStorageTraceAdapter;
import io.datarouter.storage.node.entity.EntityNodeParams;
import io.datarouter.storage.node.op.raw.BlobStorage;
import io.datarouter.storage.node.op.raw.GroupQueueStorage;
import io.datarouter.storage.node.op.raw.QueueStorage;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import io.datarouter.web.config.service.ServiceName;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FilesystemClientNodeFactory
extends BaseClientNodeFactory
implements BlobClientNodeFactory,
QueueClientNodeFactory {
    @Inject
    private FilesystemClientType clientType;
    @Inject
    private ServiceName serviceName;
    @Inject
    private FilesystemNodeFactory filesystemNodeFactory;
    @Inject
    private DirectoryManager.DirectoryManagerFactory directoryManagerFactory;
    @Inject
    private FilesystemOptions filesystemOptions;

    public <EK extends EntityKey<EK>, E extends Entity<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> WrappedNodeFactory<EK, E, PK, D, F, QueueStorage.PhysicalQueueStorageNode<PK, D, F>> makeWrappedNodeFactory() {
        return new FilesystemWrappedNodeFactory();
    }

    public BlobStorage.PhysicalBlobStorageNode createBlobNode(NodeParams<PathbeanKey, Pathbean, Pathbean.PathbeanFielder> nodeParams) {
        DirectoryBlobStorage directoryBlobStorage = this.makeDirectoryObjectStorage(nodeParams);
        return new DirectoryBlobStorageNode(nodeParams, this.clientType, directoryBlobStorage, nodeParams.getPhysicalName(), nodeParams.getPath());
    }

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> PhysicalNode<PK, D, F> createSingleQueueNode(NodeParams<PK, D, F> nodeParams) {
        DirectoryQueueNode<PK, D, F> node = this.filesystemNodeFactory.createSingleNode(this.makeDirectoryQueue(nodeParams), nodeParams);
        return new PhysicalQueueStorageTraceAdapter((QueueStorage.PhysicalQueueStorageNode)new PhysicalQueueStorageCounterAdapter((QueueStorage.PhysicalQueueStorageNode)new PhysicalQueueStorageSanitizationAdapter(node)));
    }

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> PhysicalNode<PK, D, F> createGroupQueueNode(NodeParams<PK, D, F> nodeParams) {
        DirectoryGroupQueueNode<PK, D, F> node = this.filesystemNodeFactory.createGroupNode(this.makeDirectoryQueue(nodeParams), nodeParams);
        return new PhysicalGroupQueueStorageTraceAdapter((GroupQueueStorage.PhysicalGroupQueueStorageNode)new PhysicalGroupQueueStorageCounterAdapter((GroupQueueStorage.PhysicalGroupQueueStorageNode)new PhysicalGroupQueueStorageSanitizationAdapter(node)));
    }

    private DirectoryBlobStorage makeDirectoryObjectStorage(NodeParams<?, ?, ?> nodeParams) {
        Path rootPath = this.filesystemOptions.getRoot(nodeParams.getClientName());
        String relativePathString = (String)Scanner.of((Object[])new String[]{nodeParams.getPhysicalName(), nodeParams.getPath().toString()}).exclude(Objects::isNull).collect(Collectors.joining("/"));
        Path relativePath = Paths.get(relativePathString, new String[0]);
        Path fullPath = rootPath.resolve(relativePath);
        DirectoryManager directoryManager = this.directoryManagerFactory.create(fullPath.toString());
        return new DirectoryBlobStorage(directoryManager);
    }

    private DirectoryQueue makeDirectoryQueue(NodeParams<?, ?, ?> nodeParams) {
        Path rootPath = this.filesystemOptions.getRoot(nodeParams.getClientName());
        String relativePathString = String.join((CharSequence)"/", this.serviceName.get(), nodeParams.getPhysicalName());
        Path relativePath = Paths.get(relativePathString, new String[0]);
        Path fullPath = rootPath.resolve(relativePath);
        DirectoryManager directoryManager = this.directoryManagerFactory.create(fullPath.toString());
        return new DirectoryQueue(directoryManager);
    }

    public class FilesystemWrappedNodeFactory<EK extends EntityKey<EK>, E extends Entity<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
    extends WrappedNodeFactory<EK, E, PK, D, F, QueueStorage.PhysicalQueueStorageNode<PK, D, F>> {
        public QueueStorage.PhysicalQueueStorageNode<PK, D, F> createNode(EntityNodeParams<EK, E> entityNodeParams, NodeParams<PK, D, F> nodeParams) {
            return FilesystemClientNodeFactory.this.filesystemNodeFactory.createSingleNode(FilesystemClientNodeFactory.this.makeDirectoryQueue(nodeParams), nodeParams);
        }

        public List<UnaryOperator<QueueStorage.PhysicalQueueStorageNode<PK, D, F>>> getAdapters() {
            return List.of(PhysicalQueueStorageCounterAdapter::new, PhysicalQueueStorageSanitizationAdapter::new, PhysicalQueueStorageTraceAdapter::new);
        }
    }
}

