/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.entry;

import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;

public class SnapshotEntry {
    public static final Comparator<SnapshotEntry> KEY_COMPARATOR = Comparator.comparing(Function.identity(), (a, b) -> Arrays.compareUnsigned(a.keySlab, a.keyFrom, a.keyTo, b.keySlab, b.keyFrom, b.keyTo));
    private final byte[] keySlab;
    private final int keyFrom;
    private final int keyTo;
    private final byte[] valueSlab;
    private final int valueFrom;
    private final int valueTo;
    public final byte[][] columnValues;

    public SnapshotEntry(byte[] keySlab, byte[] valueSlab, byte[][] columnValues) {
        this.keySlab = keySlab;
        this.keyFrom = 0;
        this.keyTo = keySlab.length;
        this.valueSlab = valueSlab;
        this.valueFrom = 0;
        this.valueTo = valueSlab.length;
        this.columnValues = columnValues;
    }

    public SnapshotEntry(byte[] key, int keyFrom, int keyTo, byte[] value, int valueFrom, int valueTo, byte[][] columnValues) {
        this.keySlab = key;
        this.keyFrom = keyFrom;
        this.keyTo = keyTo;
        this.valueSlab = value;
        this.valueFrom = valueFrom;
        this.valueTo = valueTo;
        this.columnValues = columnValues;
    }

    public byte[] keySlab() {
        return this.keySlab;
    }

    public int keyFrom() {
        return this.keyFrom;
    }

    public int keyTo() {
        return this.keyTo;
    }

    public int keyLength() {
        return this.keyTo - this.keyFrom;
    }

    public byte[] key() {
        if (this.keyFrom == 0 && this.keyTo == this.keySlab.length) {
            return this.keySlab;
        }
        return Arrays.copyOfRange(this.keySlab, this.keyFrom, this.keyTo);
    }

    public byte[] valueSlab() {
        return this.valueSlab;
    }

    public int valueFrom() {
        return this.valueFrom;
    }

    public int valueTo() {
        return this.valueTo;
    }

    public int valueLength() {
        return this.valueTo - this.valueFrom;
    }

    public byte[] value() {
        if (this.valueFrom == 0 && this.valueTo == this.valueSlab.length) {
            return this.valueSlab;
        }
        return Arrays.copyOfRange(this.valueSlab, this.valueFrom, this.valueTo);
    }

    public static boolean isSorted(SnapshotEntry first, SnapshotEntry second, boolean duplicatesAllowed) {
        int diff = Arrays.compareUnsigned(first.keySlab, first.keyFrom, first.keyTo, second.keySlab, second.keyFrom, second.keyTo);
        if (duplicatesAllowed) {
            return diff <= 0;
        }
        return diff < 0;
    }

    public static boolean equal(SnapshotEntry left, SnapshotEntry right) {
        return SnapshotEntry.equalKeys(left, right) && SnapshotEntry.equalColumnValues(left, right);
    }

    public static boolean equalKeys(SnapshotEntry left, SnapshotEntry right) {
        return Arrays.equals(left.key(), right.key());
    }

    public static boolean equalColumnValues(SnapshotEntry left, SnapshotEntry right) {
        if (left.columnValues.length != right.columnValues.length) {
            return false;
        }
        int i = 0;
        while (i < left.columnValues.length) {
            if (!SnapshotEntry.equalColumnValue(left, right, i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalColumnValue(SnapshotEntry left, SnapshotEntry right, int valueIndex) {
        return Arrays.equals(left.columnValues[valueIndex], right.columnValues[valueIndex]);
    }
}

