/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.block.root;

import io.datarouter.bytes.ByteReader;
import io.datarouter.filesystem.snapshot.block.Block;
import io.datarouter.filesystem.snapshot.block.BlockKey;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.util.number.NumberFormatter;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;

public interface RootBlock
extends Block {
    public static String type(byte[] bytes) {
        return new ByteReader(bytes).varUtf8();
    }

    public boolean sorted();

    public String pathFormat();

    public String branchBlockType();

    public String leafBlockType();

    public String valueBlockType();

    public String branchBlockCompressor();

    public String leafBlockCompressor();

    public String valueBlockCompressor();

    public int branchBytesPerFile();

    public int leafBytesPerFile();

    public int valueBytesPerFile();

    public int branchBlocksPerFile();

    public int leafBlocksPerFile();

    public int valueBlocksPerFile();

    public long numRecords();

    public int numBranchBlocks();

    public int numBranchBlocks(int var1);

    public int numLeafBlocks();

    public int numColumns();

    public int numValueBlocks(int var1);

    public int numValueBlocks();

    public int numBranchLevels();

    default public int maxBranchLevel() {
        return this.numBranchLevels() - 1;
    }

    public long numRootBytesEncoded();

    public long numBranchBytesEncoded();

    public long numLeafBytesEncoded();

    public long numValueBytesEncoded();

    default public long totalBytesEncoded() {
        return this.numRootBytesEncoded() + this.numBranchBytesEncoded() + this.numLeafBytesEncoded() + this.numValueBytesEncoded();
    }

    public long numBranchBytesCompressed();

    public long numLeafBytesCompressed();

    public long numValueBytesCompressed();

    default public long totalBytesCompressed() {
        return this.numRootBytesEncoded() + this.numBranchBytesCompressed() + this.numLeafBytesCompressed() + this.numValueBytesCompressed();
    }

    public long writeStartTimeMs();

    public long writeDurationMs();

    default public Duration writeDuration() {
        return Duration.ofMillis(this.writeDurationMs());
    }

    default public int branchFileId(int level, int blockId) {
        return blockId / this.branchBlocksPerFile();
    }

    default public int leafFileId(int blockId) {
        return blockId / this.leafBlocksPerFile();
    }

    default public int valueFileId(int blockId) {
        return blockId / this.valueBlocksPerFile();
    }

    public int rootBranchBlockEnding();

    default public BlockKey rootBranchBlockKey(SnapshotKey snapshotKey) {
        return BlockKey.branch(snapshotKey, this.maxBranchLevel(), 0, 0, 0, this.rootBranchBlockEnding());
    }

    public int numDictionaryEntries();

    public byte[] dictionaryKey(int var1);

    public byte[] dictionaryValue(int var1);

    default public LinkedHashMap<String, String> toKeyValueStrings() {
        LinkedHashMap<String, String> kvs = new LinkedHashMap<String, String>();
        kvs.put("sorted", Boolean.toString(this.sorted()));
        kvs.put("branchBlockType", this.branchBlockType());
        kvs.put("leafBlockType", this.leafBlockType());
        kvs.put("valueBlockType", this.valueBlockType());
        kvs.put("branchBlockCompressor", this.branchBlockCompressor());
        kvs.put("leafBlockCompressor", this.leafBlockCompressor());
        kvs.put("valueBlockCompressor", this.valueBlockCompressor());
        kvs.put("branchBytesPerFile", NumberFormatter.addCommas((Number)this.branchBytesPerFile()));
        kvs.put("leafBytesPerFile", NumberFormatter.addCommas((Number)this.leafBytesPerFile()));
        kvs.put("valueBytesPerFile", NumberFormatter.addCommas((Number)this.valueBytesPerFile()));
        kvs.put("branchBlocksPerFile", NumberFormatter.addCommas((Number)this.branchBlocksPerFile()));
        kvs.put("leafBlocksPerFile", NumberFormatter.addCommas((Number)this.leafBlocksPerFile()));
        kvs.put("valueBlocksPerFile", NumberFormatter.addCommas((Number)this.valueBlocksPerFile()));
        kvs.put("numEntries", NumberFormatter.addCommas((Number)this.numRecords()));
        kvs.put("numBranchLevels", NumberFormatter.addCommas((Number)this.numBranchLevels()));
        kvs.put("numBranchBlocks", NumberFormatter.addCommas((Number)this.numBranchBlocks()));
        kvs.put("numLeafBlocks", NumberFormatter.addCommas((Number)this.numLeafBlocks()));
        kvs.put("numValueBlocks", NumberFormatter.addCommas((Number)this.numValueBlocks()));
        kvs.put("numBranchBytesEncoded", NumberFormatter.addCommas((Number)this.numBranchBytesEncoded()));
        kvs.put("numLeafBytesEncoded", NumberFormatter.addCommas((Number)this.numLeafBytesEncoded()));
        kvs.put("numValueBytesEncoded", NumberFormatter.addCommas((Number)this.numValueBytesEncoded()));
        kvs.put("numBranchBytesCompressed", NumberFormatter.addCommas((Number)this.numBranchBytesCompressed()));
        kvs.put("numLeafBytesCompressed", NumberFormatter.addCommas((Number)this.numLeafBytesCompressed()));
        kvs.put("numValueBytesCompressed", NumberFormatter.addCommas((Number)this.numValueBytesCompressed()));
        kvs.put("writeStartTime", Instant.ofEpochMilli(this.writeStartTimeMs()).toString());
        kvs.put("writeDuration", this.writeDuration().toString());
        kvs.put("writeItemsPerSecond", RootBlock.perSecond(this.numRecords(), this.writeDuration()));
        kvs.put("writeEncodedBytesPerSecond", RootBlock.perSecond(this.totalBytesEncoded(), this.writeDuration()));
        kvs.put("writeCompressedBytesPerSecond", RootBlock.perSecond(this.totalBytesCompressed(), this.writeDuration()));
        kvs.put("numDictionaryEntries", NumberFormatter.addCommas((Number)this.numDictionaryEntries()));
        return kvs;
    }

    private static String perSecond(long count, Duration duration) {
        double perSecond = (double)count * 1000.0 / (double)duration.toMillis();
        return NumberFormatter.addCommas((Number)((long)perSecond));
    }
}

