/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.entry;

import io.datarouter.bytes.ByteWriter;
import io.datarouter.bytes.PagedObjectArray;
import io.datarouter.filesystem.snapshot.entry.SnapshotEntry;
import java.util.Arrays;
import java.util.List;

public class SnapshotEntrySlabBuilder {
    private final ByteWriter keyWriter = new ByteWriter(64);
    private int keyEnding = 0;
    private final PagedObjectArray<Integer> keyEndings = new PagedObjectArray(64);
    private final ByteWriter valueWriter = new ByteWriter(64);
    private int valueEnding = 0;
    private final PagedObjectArray<Integer> valueEndings = new PagedObjectArray(64);
    private final PagedObjectArray<byte[][]> columnValuesList = new PagedObjectArray(64);

    public void append(byte[] key, byte[] value, byte[][] columnValues) {
        this.keyWriter.bytes(key);
        this.keyEnding += key.length;
        this.keyEndings.add((Object)this.keyEnding);
        this.valueWriter.bytes(value);
        this.valueEnding += value.length;
        this.valueEndings.add((Object)this.valueEnding);
        this.columnValuesList.add((Object)columnValues);
    }

    public List<SnapshotEntry> build() {
        int numEntries = this.keyEndings.size();
        byte[] keySlab = this.keyWriter.concat();
        byte[] valueSlab = this.valueWriter.concat();
        SnapshotEntry[] entries = new SnapshotEntry[numEntries];
        int i = 0;
        while (i < numEntries) {
            int keyFrom = i == 0 ? 0 : (Integer)this.keyEndings.get(i - 1);
            int keyTo = (Integer)this.keyEndings.get(i);
            int valueFrom = i == 0 ? 0 : (Integer)this.valueEndings.get(i - 1);
            int valueTo = (Integer)this.valueEndings.get(i);
            entries[i] = new SnapshotEntry(keySlab, keyFrom, keyTo, valueSlab, valueFrom, valueTo, (byte[][])this.columnValuesList.get(i));
            ++i;
        }
        return Arrays.asList(entries);
    }
}

