/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.compress;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.codec.longcodec.RawLongCodec;
import io.datarouter.filesystem.snapshot.compress.BlockCompressor;
import io.datarouter.filesystem.snapshot.compress.CompressedBlock;
import io.datarouter.filesystem.snapshot.encode.EncodedBlock;
import java.util.zip.CRC32;

public class ChecksumBlockCompressor
implements BlockCompressor {
    public static final String NAME = "checksum";
    private static final RawLongCodec RAW_LONG_CODEC = RawLongCodec.INSTANCE;

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public CompressedBlock compress(EncodedBlock encodedBlock, boolean concatChunks) {
        CRC32 crc = new CRC32();
        byte[][] chunksAndChecksum = new byte[encodedBlock.chunks.length + 1][];
        int i = 0;
        while (i < encodedBlock.chunks.length) {
            crc.update(encodedBlock.chunks[i]);
            chunksAndChecksum[i] = encodedBlock.chunks[i];
            ++i;
        }
        byte[] checksum = RAW_LONG_CODEC.encode(crc.getValue());
        chunksAndChecksum[encodedBlock.chunks.length] = checksum;
        return new CompressedBlock(chunksAndChecksum);
    }

    @Override
    public byte[] decompress(byte[] withChecksum, boolean validateChecksum) {
        byte[] withoutChecksum = ByteTool.copyOfRange((byte[])withChecksum, (int)0, (int)(withChecksum.length - 8));
        if (validateChecksum) {
            CRC32 crc = new CRC32();
            crc.update(withoutChecksum);
            long expectedChecksum = RAW_LONG_CODEC.decode(withChecksum, withChecksum.length - 8);
            long actualChecksum = crc.getValue();
            if (expectedChecksum != actualChecksum) {
                String message = String.format("invalid checksum, expected=%s, actual=%s", expectedChecksum, actualChecksum);
                throw new IllegalStateException(message);
            }
        }
        return withoutChecksum;
    }
}

