/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.block.value;

import io.datarouter.bytes.PagedObjectArray;
import io.datarouter.bytes.VarIntTool;
import io.datarouter.bytes.codec.intcodec.RawIntCodec;
import io.datarouter.filesystem.snapshot.encode.EncodedBlock;
import io.datarouter.filesystem.snapshot.encode.ValueBlockEncoder;
import io.datarouter.filesystem.snapshot.entry.SnapshotEntry;

public class ValueBlockV1Encoder
implements ValueBlockEncoder {
    private static final RawIntCodec RAW_INT_CODEC = RawIntCodec.INSTANCE;
    private int numRecords = 0;
    private int numBytes = 0;
    private final PagedObjectArray<byte[]> values = new PagedObjectArray(256);

    @Override
    public void add(SnapshotEntry entry, int column) {
        ++this.numRecords;
        byte[] value = entry.columnValues[column];
        this.numBytes += value.length;
        this.values.add((Object)value);
    }

    @Override
    public String format() {
        return "valueV1";
    }

    @Override
    public int numRecords() {
        return this.values.size();
    }

    @Override
    public int numBytes() {
        return this.numBytes;
    }

    @Override
    public EncodedBlock encode() {
        byte[] headerChunk = VarIntTool.encode((long)this.numRecords);
        byte[] endingsChunk = new byte[this.values.size() * 4];
        byte[] valuesChunk = new byte[this.numBytes];
        int ending = 0;
        int endingsCursor = 0;
        int valuesCursor = 0;
        for (byte[] value : this.values) {
            int valueLength = value.length;
            RAW_INT_CODEC.encode(ending += valueLength, endingsChunk, endingsCursor);
            endingsCursor += 4;
            System.arraycopy(value, 0, valuesChunk, valuesCursor, valueLength);
            valuesCursor += valueLength;
        }
        byte[][] chunks = new byte[][]{headerChunk, endingsChunk, valuesChunk};
        return new EncodedBlock(chunks);
    }
}

