/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.email.html;

import io.datarouter.gson.DatarouterGsons;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.number.NumberFormatter;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.TableTag;
import j2html.tags.specialized.TbodyTag;
import j2html.tags.specialized.TdTag;
import j2html.tags.specialized.TheadTag;
import j2html.tags.specialized.TrTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class J2HtmlEmailTable<T> {
    private final List<J2HtmlEmailTableColumn<T>> j2HtmlEmailTableColumns = new ArrayList<J2HtmlEmailTableColumn<T>>();

    public J2HtmlEmailTable<T> withColumn(String name, Function<T, Object> valueFunction) {
        this.j2HtmlEmailTableColumns.add(J2HtmlEmailTableColumn.ofText(name, valueFunction));
        return this;
    }

    public J2HtmlEmailTable<T> withColumn(J2HtmlEmailTableColumn<T> column) {
        this.j2HtmlEmailTableColumns.add(column);
        return this;
    }

    public TableTag build(Collection<T> values) {
        return this.build(values, J2HtmlEmailTableRow::new);
    }

    public TableTag build(Collection<T> values, Function<T, J2HtmlEmailTableRow<T>> rowFunction) {
        List rows = Scanner.of(values).map(rowFunction).list();
        boolean includeHead = Scanner.of(this.j2HtmlEmailTableColumns).map(column -> column.name).anyMatch(Objects::nonNull);
        TheadTag thead = TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.each(this.j2HtmlEmailTableColumns, column -> TagCreator.th((String)column.name).withStyle(String.join((CharSequence)";", column.styles) + ";"))})});
        TbodyTag tbody = TagCreator.tbody((DomContent[])new DomContent[]{TagCreator.each((Collection)rows, this::makeTr)});
        return (TableTag)((TableTag)((TableTag)((TableTag)((TableTag)TagCreator.table().attr("border", (Object)1)).attr("cellpadding", (Object)5)).withStyle("border-collapse:collapse;")).condWith(includeHead, (DomContent)thead)).with((DomContent)tbody);
    }

    private TrTag makeTr(J2HtmlEmailTableRow<T> row) {
        TrTag tableRow = TagCreator.tr();
        if (!row.styles.isEmpty()) {
            tableRow.withStyle(String.join((CharSequence)";", row.styles) + ";");
        }
        return (TrTag)tableRow.with(TagCreator.each(this.j2HtmlEmailTableColumns, column -> this.makeTd((J2HtmlEmailTableColumn<T>)column, j2HtmlEmailTableRow.value)));
    }

    private TdTag makeTd(J2HtmlEmailTableColumn<T> column, T row) {
        TdTag td = TagCreator.td((DomContent[])new DomContent[]{column.valueFunction.apply(row)});
        if (!column.styles.isEmpty()) {
            td.withStyle(String.join((CharSequence)";", column.styles) + ";");
        }
        return td;
    }

    public static class J2HtmlEmailTableColumn<T> {
        private final String name;
        private final Function<T, DomContent> valueFunction;
        private final List<String> styles;

        public J2HtmlEmailTableColumn(String name, Function<T, DomContent> valueFunction) {
            this.name = name;
            this.valueFunction = valueFunction;
            this.styles = new ArrayList<String>();
        }

        public static <T> J2HtmlEmailTableColumn<T> ofNumber(String name, Function<T, Number> valueFunction) {
            return J2HtmlEmailTableColumn.ofText(name, valueFunction.andThen(NumberFormatter::addCommas)).withStyle("text-align:right");
        }

        public static <T> J2HtmlEmailTableColumn<T> ofText(String name, Function<T, Object> valueFunction) {
            return new J2HtmlEmailTableColumn<Object>(name, row -> {
                try {
                    Object value = valueFunction.apply(row);
                    String text = Optional.ofNullable(value).map(Object::toString).orElse("");
                    return TagCreator.text((String)text);
                }
                catch (Exception e) {
                    throw new RuntimeException("error column=" + name + " row=" + DatarouterGsons.withoutEnums().toJson(row), e);
                }
            });
        }

        public J2HtmlEmailTableColumn<T> withStyle(String style) {
            this.styles.add(style);
            return this;
        }
    }

    public static class J2HtmlEmailTableRow<T> {
        private final T value;
        private final List<String> styles;

        public J2HtmlEmailTableRow(T value) {
            this.value = value;
            this.styles = new ArrayList<String>();
        }

        public J2HtmlEmailTableRow<T> withStyle(String style) {
            this.styles.add(style);
            return this;
        }
    }
}

