/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.email.email;

import io.datarouter.email.email.DatarouterEmailFiles;
import io.datarouter.email.email.DatarouterEmailLinkBuilder;
import io.datarouter.email.email.DatarouterEmailPaths;
import io.datarouter.email.email.EmailService;
import io.datarouter.email.html.EmailDto;
import io.datarouter.email.html.J2HtmlDatarouterEmail;
import io.datarouter.email.html.J2HtmlDatarouterEmailBuilder;
import io.datarouter.util.string.StringTool;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.List;

@Singleton
public class IDatarouterEmailService {
    @Inject
    private EmailService emailService;
    @Inject
    private DatarouterEmailFiles files;
    @Inject
    private DatarouterEmailPaths paths;

    public SendEmailRecipients trySend(EmailDto email, String adminEmail, boolean includeSubscribers, Collection<String> subscribers) {
        String fromEmail = email.fromAdmin ? adminEmail : email.fromEmail;
        List<String> toEmails = email.toEmails;
        if (email.toAdmin) {
            toEmails.add(adminEmail);
        }
        if (email.toSubscribers && includeSubscribers) {
            toEmails.addAll(subscribers);
        }
        this.emailService.trySend(fromEmail, toEmails, email.subject, email.content, email.html);
        return new SendEmailRecipients(fromEmail, toEmails);
    }

    public SendEmailRecipients trySendJ2Html(J2HtmlDatarouterEmailBuilder emailBuilder, String adminEmail, boolean includeSubscribers, Collection<String> subscribers) {
        J2HtmlDatarouterEmail email = emailBuilder.build();
        String fromEmail = email.fromAdmin ? adminEmail : email.fromEmail;
        List<String> toEmails = email.toEmails;
        if (email.toAdmin) {
            toEmails.add(adminEmail);
        }
        if (email.toSubscribers && includeSubscribers) {
            toEmails.addAll(subscribers);
        }
        String bodyString = email.build().render();
        this.emailService.trySend(fromEmail, toEmails, emailBuilder.getSubject(), bodyString, true);
        return new SendEmailRecipients(fromEmail, toEmails);
    }

    public DatarouterEmailLinkBuilder startLinkBuilder(String hostPort, String contextPath) {
        return new DatarouterEmailLinkBuilder().withProtocol("https").withHostPort(hostPort).withContextPath(contextPath);
    }

    public J2HtmlDatarouterEmailBuilder startEmailBuilderWithOutLogo(String serviceName, String environmentName) {
        return new J2HtmlDatarouterEmailBuilder().withWebappName(serviceName).withEnvironment(environmentName).withIncludeLogo(false);
    }

    public J2HtmlDatarouterEmailBuilder startEmailBuilderWithLogo(String hostPort, String contextPath, String serviceName, String environmentName, String configuredLogoHref) {
        String logoImgSrc = StringTool.notEmpty((String)configuredLogoHref) ? configuredLogoHref : this.startLinkBuilder(hostPort, contextPath).withLocalPath(this.files.jeeAssets.datarouterLogoPng).build();
        String logoHref = this.startLinkBuilder(hostPort, contextPath).withLocalPath(this.paths.datarouter).build();
        return new J2HtmlDatarouterEmailBuilder().withWebappName(serviceName).withEnvironment(environmentName).withIncludeLogo(true).withLogoImgSrc(logoImgSrc).withLogoHref(logoHref);
    }

    public record SendEmailRecipients(String from, List<String> to) {
    }
}

