/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.email.email;

import io.datarouter.email.config.DatarouterEmailSettings;
import io.datarouter.email.config.DatarouterEmailSettingsProvider;
import io.datarouter.email.dto.DatarouterEmailFileAttachmentDto;
import io.datarouter.email.util.MimeMessageTool;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.string.StringTool;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EmailService {
    private static final Logger logger = LoggerFactory.getLogger(EmailService.class);
    @Inject
    private DatarouterEmailSettingsProvider datarouterEmailSettingsProvider;

    @Deprecated
    public void trySend(String fromEmail, String toEmails, String subject, String body) {
        this.trySend(fromEmail, List.of(toEmails), subject, body, false);
    }

    public void trySend(String fromEmail, Collection<String> toEmails, String subject, String body) {
        this.trySend(fromEmail, toEmails, subject, body, false);
    }

    @Deprecated
    public void trySend(String fromEmail, String toEmails, String subject, String body, boolean html) {
        this.trySend(fromEmail, List.of(toEmails), subject, body, html);
    }

    public void trySend(String fromEmail, Collection<String> toEmails, String subject, String body, boolean html) {
        try {
            this.send(fromEmail, toEmails, subject, body, html);
        }
        catch (MessagingException e) {
            logger.error("failed to send email from={} to={}", new Object[]{fromEmail, String.join((CharSequence)",", toEmails), e});
        }
    }

    @Deprecated
    public void send(String fromEmail, String toEmails, String subject, String body, boolean html) throws MessagingException {
        this.send(fromEmail, List.of(toEmails), subject, body, html);
    }

    public void send(String fromEmail, Collection<String> toEmails, String subject, String body, boolean html) throws MessagingException {
        String emailId = this.sendAndGetMessageId(fromEmail, toEmails, toEmails, subject, body, html, Map.of(), List.of()).orElse("null");
        logger.warn("emailId={}, subject={}", (Object)emailId, (Object)subject);
    }

    public Optional<String> sendAndGetMessageId(String fromEmail, Collection<String> toEmails, Collection<String> replyToEmails, String subject, String body, boolean html, Map<String, String> headers, List<DatarouterEmailFileAttachmentDto> fileAttachmentDtos) throws MessagingException {
        if (!((Boolean)this.datarouterEmailSettingsProvider.get().sendDatarouterEmails.get()).booleanValue()) {
            return Optional.empty();
        }
        Properties props = new Properties();
        DatarouterEmailSettings.DatarouterEmailHostDetails emailHostDetails = this.datarouterEmailSettingsProvider.get().getDatarouterEmailHostDetails();
        if (StringTool.notNullNorEmpty((String)emailHostDetails.smtpPassword())) {
            props.put("mail.smtp.auth", "true");
            props.put("mail.smtp.starttls.enable", "true");
        }
        String host = StringTool.nullIfEmpty((String)emailHostDetails.smtpHost());
        int port = emailHostDetails.smtpPort();
        String username = StringTool.nullIfEmpty((String)emailHostDetails.smtpUsername());
        String password = StringTool.nullIfEmpty((String)emailHostDetails.smtpPassword());
        Session session = Session.getInstance((Properties)props);
        Throwable throwable = null;
        Object var17_18 = null;
        try (Transport transport = session.getTransport();){
            MimeMultipart multipart;
            transport.connect(host, port, username, password);
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(fromEmail));
            String toRecipients = (String)Scanner.of(toEmails).distinct().sort().collect(Collectors.joining(","));
            InternetAddress[] addresses = InternetAddress.parse((String)toRecipients);
            message.addRecipients(Message.RecipientType.TO, (Address[])addresses);
            String replyToEmailsString = (String)Scanner.of(replyToEmails).distinct().sort().collect(Collectors.joining(","));
            message.setReplyTo((Address[])InternetAddress.parse((String)replyToEmailsString));
            message.setSubject(subject);
            headers.forEach((key, value) -> MimeMessageTool.setHeader(message, key, value));
            String subType = html ? "html" : "plain";
            MimeBodyPart textHtml = new MimeBodyPart();
            textHtml.setText(body, "UTF-8", subType);
            if (Scanner.of(fileAttachmentDtos).anyMatch(attachment -> attachment.isInlineContent)) {
                multipart = new MimeMultipart("related");
                MimeBodyPart bodyPart = new MimeBodyPart();
                MimeMultipart alternative = new MimeMultipart("alternative");
                alternative.addBodyPart((BodyPart)textHtml);
                bodyPart.setContent((Multipart)alternative);
                multipart.addBodyPart((BodyPart)bodyPart);
            } else {
                multipart = new MimeMultipart(new BodyPart[]{textHtml});
            }
            Scanner.of(fileAttachmentDtos).map(MimeMessageTool::buildMimeBodyPartForAttachment).forEach(arg_0 -> EmailService.lambda$3((Multipart)multipart, arg_0));
            message.setContent((Multipart)multipart);
            transport.sendMessage((Message)message, (Address[])addresses);
            return Optional.ofNullable(message.getMessageID());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static /* synthetic */ void lambda$3(Multipart multipart, MimeBodyPart mimeBodyPart) {
        MimeMessageTool.addBodyPartToMultipart(multipart, mimeBodyPart);
    }
}

