/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.email.email;

import io.datarouter.email.config.DatarouterEmailSettingsProvider;
import io.datarouter.email.email.DatarouterEmailLinkBuilder;
import io.datarouter.email.email.IDatarouterEmailService;
import io.datarouter.email.html.EmailDto;
import io.datarouter.email.html.J2HtmlDatarouterEmail;
import io.datarouter.email.html.J2HtmlDatarouterEmailBuilder;
import io.datarouter.instrumentation.web.ContextName;
import io.datarouter.storage.config.DatarouterSubscribersSupplier;
import io.datarouter.storage.config.properties.AdminEmail;
import io.datarouter.storage.config.properties.EnvironmentName;
import io.datarouter.storage.config.properties.ServiceName;
import io.datarouter.storage.config.setting.DatarouterEmailSubscriberSettings;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatarouterHtmlEmailService {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterHtmlEmailService.class);
    @Inject
    private ServiceName serviceName;
    @Inject
    private DatarouterEmailSettingsProvider datarouterEmailSettingsProvider;
    @Inject
    private AdminEmail adminEmail;
    @Inject
    private DatarouterSubscribersSupplier subscribersEmail;
    @Deprecated
    @Inject
    private DatarouterEmailSubscriberSettings subscriberSettings;
    @Inject
    private EnvironmentName environmentName;
    @Inject
    private ContextName contextName;
    @Inject
    private IDatarouterEmailService emailService;

    public IDatarouterEmailService.SendEmailRecipients trySend(EmailDto email) {
        return this.emailService.trySend(email, this.adminEmail.get(), (Boolean)this.subscriberSettings.includeSubscribers.get(), this.subscribersEmail.get());
    }

    public IDatarouterEmailService.SendEmailRecipients trySendJ2Html(J2HtmlDatarouterEmailBuilder emailBuilder) {
        return this.emailService.trySendJ2Html(emailBuilder, this.adminEmail.get(), (Boolean)this.subscriberSettings.includeSubscribers.get(), this.subscribersEmail.get());
    }

    public Set<String> getCompleteToEmails(J2HtmlDatarouterEmail email) {
        if (email.toAdmin) {
            email.toEmails.add(this.adminEmail.get());
        }
        if (email.toSubscribers && ((Boolean)this.subscriberSettings.includeSubscribers.get()).booleanValue()) {
            email.toEmails.addAll(this.subscribersEmail.get());
        }
        return new HashSet<String>(email.toEmails);
    }

    public DatarouterEmailLinkBuilder startLinkBuilder() {
        return this.emailService.startLinkBuilder((String)this.datarouterEmailSettingsProvider.get().emailLinkHostPort.get(), this.contextName.getContextPath());
    }

    public J2HtmlDatarouterEmailBuilder startEmailBuilder() {
        boolean includeLogo = (Boolean)this.datarouterEmailSettingsProvider.get().includeLogo.get();
        if (includeLogo) {
            String hostPort = (String)this.datarouterEmailSettingsProvider.get().emailLinkHostPort.get();
            logger.warn("emailLinkHostPort used value={}", (Object)hostPort);
            return this.emailService.startEmailBuilderWithLogo(hostPort, this.contextName.getContextPath(), this.serviceName.get(), this.environmentName.get(), (String)this.datarouterEmailSettingsProvider.get().logoImgSrc.get());
        }
        return this.emailService.startEmailBuilderWithOutLogo(this.serviceName.get(), this.environmentName.get());
    }
}

