/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.changelog.service;

import io.datarouter.changelog.config.DatarouterChangelogPaths;
import io.datarouter.changelog.storage.Changelog;
import io.datarouter.changelog.storage.ChangelogKey;
import io.datarouter.util.DateTool;
import io.datarouter.util.number.RandomTool;
import io.datarouter.web.config.ServletContextSupplier;
import io.datarouter.web.html.j2html.J2HtmlTable;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import org.apache.http.client.utils.URIBuilder;

@Singleton
public class ViewChangelogService {
    @Inject
    private ServletContextSupplier servletContext;
    @Inject
    private DatarouterChangelogPaths paths;

    public ContainerTag buildTable(List<Changelog> rows, ZoneId zoneId) {
        return new J2HtmlTable().withClasses(new String[]{"table table-sm table-striped my-4 border"}).withHtmlColumn("", row -> TagCreator.td((DomContent[])new DomContent[]{((ContainerTag)TagCreator.a().withClass("fa fa-link")).withHref(this.buildViewExactHref((Changelog)((Object)row)))})).withColumn("Date", row -> {
            Long reversedDateMs = ((ChangelogKey)row.getKey()).getReversedDateMs();
            Date date = new Date(Long.MAX_VALUE - reversedDateMs);
            return DateTool.formatDateWithZone((Date)date, (ZoneId)zoneId);
        }).withColumn("Type", row -> ((ChangelogKey)row.getKey()).getChangelogType()).withColumn("Name", row -> ((ChangelogKey)row.getKey()).getName()).withColumn("Action", row -> row.getAction()).withColumn("User", row -> row.getUsername()).withHtmlColumn("Comment", row -> {
            String id = "" + ((ChangelogKey)row.getKey()).getReversedDateMs() + RandomTool.nextPositiveInt();
            return this.makeModal(id, row.getComment(), "comment");
        }).withHtmlColumn("Note", row -> {
            String id = "" + ((ChangelogKey)row.getKey()).getReversedDateMs() + RandomTool.nextPositiveInt();
            return this.makeModal(id, row.getNote(), "note");
        }).withHtmlColumn("Edit", row -> TagCreator.td((DomContent[])new DomContent[]{((ContainerTag)TagCreator.a().withClass("fa fa-edit")).withHref(this.buildEditHref((Changelog)((Object)row)))})).build(rows);
    }

    public DomContent makeModal(String id, String comment, String type) {
        if (comment == null) {
            return TagCreator.td();
        }
        String modalId = String.valueOf(type) + "Modal" + id;
        ContainerTag commentButton = (ContainerTag)((ContainerTag)((ContainerTag)((ContainerTag)TagCreator.a().withClass("fa fa-sticky-note")).attr("data-toggle", (Object)"modal")).attr("data-target", (Object)("#" + modalId))).withHref("#" + modalId);
        ContainerTag modalBody = (ContainerTag)((ContainerTag)TagCreator.div((String)comment).withClass("modal-body")).withStyle("text-align:left");
        ContainerTag modalFooter = (ContainerTag)TagCreator.div((DomContent[])new DomContent[]{((ContainerTag)((ContainerTag)TagCreator.button((String)"Close").withType("button")).withClass("btn btn-secondary")).attr("data-dismiss", (Object)"modal")}).withClass("modal-footer");
        ContainerTag modalContent = (ContainerTag)TagCreator.div((DomContent[])new DomContent[]{modalBody, modalFooter}).withClass("modal-content");
        ContainerTag modalDialog = (ContainerTag)((ContainerTag)TagCreator.div((DomContent[])new DomContent[]{modalContent}).withClass("modal-dialog")).withRole("document");
        ContainerTag modal = (ContainerTag)((ContainerTag)((ContainerTag)((ContainerTag)TagCreator.div((DomContent[])new DomContent[]{modalDialog}).withClass("modal fade")).withId(modalId)).attr("tabindex", (Object)"-1")).withRole("dialog");
        return TagCreator.td((DomContent[])new DomContent[]{TagCreator.div((DomContent[])new DomContent[]{commentButton, modal})}).withStyle("text-align:center");
    }

    public String buildViewExactHref(Changelog log) {
        ChangelogKey key = (ChangelogKey)log.getKey();
        return new URIBuilder().setPath(String.valueOf(((ServletContext)this.servletContext.get()).getContextPath()) + this.paths.datarouter.changelog.viewExact.toSlashedString()).addParameter("reversedDateMs", key.getReversedDateMs().toString()).addParameter("changelogType", key.getChangelogType()).addParameter("name", key.getName()).toString();
    }

    public String buildEditHref(Changelog log) {
        ChangelogKey key = (ChangelogKey)log.getKey();
        return new URIBuilder().setPath(String.valueOf(((ServletContext)this.servletContext.get()).getContextPath()) + this.paths.datarouter.changelog.edit.toSlashedString()).addParameter("reversedDateMs", key.getReversedDateMs().toString()).addParameter("changelogType", key.getChangelogType()).addParameter("name", key.getName()).toString();
    }
}

