/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.changelog.web;

import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.scanner.Scanner;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.types.Param;
import io.datarouter.web.handler.types.optional.OptionalString;
import io.datarouter.web.html.form.HtmlForm;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4FormHtml;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.FormTag;
import javax.inject.Inject;

public class ManualChangelogHandler
extends BaseHandler {
    private static final String P_name = "name";
    private static final String P_action = "action";
    private static final String P_toEmail = "toEmail";
    private static final String P_note = "note";
    private static final String P_submitAction = "submitAction";
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private ChangelogRecorder changelogRecorder;

    @BaseHandler.Handler(defaultHandler=true)
    public Mav insert(@Param(value="name") OptionalString name, @Param(value="action") OptionalString action, @Param(value="toEmail") OptionalString toEmail, @Param(value="note") OptionalString note, @Param(value="submitAction") OptionalString submitAction) {
        HtmlForm form = new HtmlForm().withMethod("post");
        form.addTextField().withDisplay("Name").withName(P_name).withPlaceholder("Xyz Migration").withValue((String)name.orElse(null));
        form.addTextField().withDisplay("Action").withName(P_action).withPlaceholder("Backfill").withValue((String)action.orElse(null));
        form.addTextField().withDisplay("Email To (csv) (Optional). All administrators are included by default").withName(P_toEmail).withPlaceholder("a@something.com,b@something.com").withValue((String)toEmail.orElse(null));
        form.addTextAreaField().withDisplay("Note (Optional)").withName(P_note).withPlaceholder("Migration for tables xyz").withValue((String)note.orElse(null));
        form.addButton().withDisplay("Record & Email").withValue("anything");
        if (submitAction.isEmpty() || form.hasErrors()) {
            return this.pageFactory.startBuilder(this.request).withTitle("Manual Changelog").withContent((DomContent)Html.makeContent(form)).buildMav();
        }
        String username = this.getSessionInfo().getRequiredSession().getUsername();
        ChangelogRecorder.DatarouterChangelogDtoBuilder dto = new ChangelogRecorder.DatarouterChangelogDtoBuilder("ManualEntry", (String)name.get(), (String)action.get(), username);
        note.ifPresent(arg_0 -> ((ChangelogRecorder.DatarouterChangelogDtoBuilder)dto).withNote(arg_0));
        if (toEmail.isPresent()) {
            Scanner.of((Object[])((String)toEmail.get()).split(",")).forEach(arg_0 -> ((ChangelogRecorder.DatarouterChangelogDtoBuilder)dto).additionalSendTos(arg_0));
        }
        dto.sendEmail();
        this.changelogRecorder.record(dto.build());
        return this.pageFactory.preformattedMessage(this.request, "Recorded changelog entry.");
    }

    private static class Html {
        private Html() {
        }

        public static DivTag makeContent(HtmlForm htmlForm) {
            FormTag form = (FormTag)Bootstrap4FormHtml.render((HtmlForm)htmlForm).withClass("card card-body bg-light");
            return (DivTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h2((String)"Manual Changelog Recorder"), form, TagCreator.br()}).withClass("container mt-3");
        }
    }
}

