/*
 * Copyright © 2009 HotPads (admin@hotpads.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.datarouter.bytes.blockfile.index;

public record BlockfileRowIdRange(
		long first,
		long last){

	public long numRows(){
		return last - first + 1;
	}

	public int compareTo(long rowId){
		if(last < rowId){
			return -1;
		}else if(first > rowId){
			return 1;
		}else{
			return 0;
		}
	}
}