/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.io;

import io.datarouter.bytes.io.MultiByteArrayInputStream;
import io.datarouter.scanner.InputStreamScanner;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;

public class InputStreamTool {
    public static void close(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static long count(InputStream inputStream, int bufferSize) {
        long count = 0L;
        try {
            int numRead;
            byte[] buffer = new byte[bufferSize];
            while ((numRead = inputStream.read(buffer)) != -1) {
                count += (long)numRead;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return count;
    }

    public static long countByte(InputStream inputStream, int bufferSize, byte matchByte) {
        long count = 0L;
        try {
            int numRead;
            byte[] buffer = new byte[bufferSize];
            while ((numRead = inputStream.read(buffer)) != -1) {
                int i = 0;
                while (i < numRead) {
                    if (buffer[i] == matchByte) {
                        ++count;
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return count;
    }

    public static byte readRequiredByte(InputStream inputStream) {
        try {
            int value = inputStream.read();
            if (value == -1) {
                throw new IllegalStateException("Unexpected end of stream");
            }
            return (byte)value;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static int readUntilLength(InputStream inputStream, byte[] buffer, int offset, int length) {
        try {
            int cursor = offset;
            int remaining = length;
            int totalRead = 0;
            while (remaining > 0) {
                int numRead = inputStream.read(buffer, cursor, remaining);
                if (numRead == -1) {
                    return totalRead > 0 ? totalRead : -1;
                }
                cursor += numRead;
                remaining -= numRead;
                totalRead += numRead;
            }
            return totalRead;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static byte[] readNBytes(InputStream inputStream, int len) {
        byte[] bytes = new byte[len];
        try {
            int numRead = inputStream.readNBytes(bytes, 0, len);
            if (numRead == len) {
                return bytes;
            }
            return Arrays.copyOfRange(bytes, 0, numRead);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static byte[] toArray(InputStream inputStream) {
        return InputStreamTool.toArray(inputStream, new ByteArrayOutputStream());
    }

    public static byte[] toArray(InputStream inputStream, ByteArrayOutputStream buffer) {
        buffer.reset();
        InputStreamTool.transferTo(inputStream, buffer);
        return buffer.toByteArray();
    }

    public static long transferTo(InputStream inputStream, OutputStream outputStream) {
        try {
            return inputStream.transferTo(outputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Loose catch block
     */
    public static long transferToAndClose(InputStream inputStream, OutputStream outputStream) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                long l;
                OutputStream closeOutput;
                InputStream closeInput;
                block18: {
                    block17: {
                        closeInput = inputStream;
                        closeOutput = outputStream;
                        l = inputStream.transferTo(outputStream);
                        if (closeOutput == null) break block17;
                        closeOutput.close();
                    }
                    if (closeInput == null) break block18;
                    closeInput.close();
                }
                return l;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (closeOutput != null) {
                                closeOutput.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (closeInput != null) {
                                closeInput.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static InputStream closeAtEnd(InputStream inputStream) {
        return (InputStream)InputStreamScanner.of((InputStream)inputStream).apply(MultiByteArrayInputStream::new);
    }
}

