/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.compress.gzip;

import io.datarouter.bytes.Codec;
import io.datarouter.bytes.EmptyArray;
import io.datarouter.bytes.io.InputStreamTool;
import io.datarouter.bytes.io.MultiByteArrayInputStream;
import io.datarouter.bytes.io.OutputStreamTool;
import io.datarouter.scanner.Ref;
import io.datarouter.scanner.Scanner;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GzipTool {
    public static final Codec<byte[], byte[]> CODEC = Codec.of(GzipTool::encode, GzipTool::decode);

    public static byte[] encode(byte[] input) {
        return GzipTool.encode(input, new ByteArrayOutputStream());
    }

    public static byte[] encode(byte[] input, ByteArrayOutputStream buffer) {
        buffer.reset();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(buffer);){
                gzipOutputStream.write(input, 0, input.length);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return buffer.toByteArray();
    }

    public static Scanner<byte[]> encode(InputStream input) {
        byte[] inputBuffer = new byte[8192];
        ByteArrayOutputStream outputBuffer = new ByteArrayOutputStream();
        Ref closed = new Ref((Object)false);
        try {
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputBuffer);
            return Scanner.generate(() -> InputStreamTool.readUntilLength(input, inputBuffer, 0, inputBuffer.length)).advanceUntil($ -> (Boolean)closed.get()).map(numRead -> {
                if (numRead == -1) {
                    OutputStreamTool.close(gzipOutputStream);
                    closed.set((Object)true);
                }
                if (numRead > 0) {
                    OutputStreamTool.write(gzipOutputStream, inputBuffer, 0, numRead);
                }
                if (outputBuffer.size() > 0) {
                    byte[] outputChunk = outputBuffer.toByteArray();
                    outputBuffer.reset();
                    return outputChunk;
                }
                return EmptyArray.BYTE;
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static InputStream encodeToInputStream(InputStream input) {
        return (InputStream)GzipTool.encode(input).apply(MultiByteArrayInputStream::new);
    }

    public static byte[] decode(byte[] compressedBytes) {
        return GzipTool.decode(compressedBytes, new ByteArrayOutputStream());
    }

    public static byte[] decode(byte[] compressedBytes, ByteArrayOutputStream buffer) {
        buffer.reset();
        ByteArrayInputStream compressedInputStream = new ByteArrayInputStream(compressedBytes);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (GZIPInputStream gzipInputStream = new GZIPInputStream(compressedInputStream);){
                return InputStreamTool.toArray(gzipInputStream, buffer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

