/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.compress.gzip;

import io.datarouter.bytes.Codec;
import io.datarouter.bytes.compress.gzip.GzipTool;
import java.io.ByteArrayOutputStream;

public class GzipStatefulCodec
implements Codec<byte[], byte[]> {
    private final GzipStatefulEncoder encoder = new GzipStatefulEncoder();
    private final GzipStatefulDecoder decoder = new GzipStatefulDecoder();

    @Override
    public byte[] encode(byte[] value) {
        return this.encoder.encode(value);
    }

    @Override
    public byte[] decode(byte[] encodedValue) {
        return this.decoder.decode(encodedValue);
    }

    public static class GzipStatefulDecoder {
        private ByteArrayOutputStream buffer;

        public byte[] decode(byte[] input) {
            if (this.buffer == null) {
                int initialCapacity = Math.max(16, input.length * 2);
                this.buffer = new ByteArrayOutputStream(initialCapacity);
            }
            return GzipTool.decode(input, this.buffer);
        }
    }

    public static class GzipStatefulEncoder {
        private ByteArrayOutputStream buffer;

        public byte[] encode(byte[] input) {
            if (this.buffer == null) {
                int initialCapacity = Math.max(16, input.length / 2);
                this.buffer = new ByteArrayOutputStream(initialCapacity);
            }
            return GzipTool.encode(input, this.buffer);
        }
    }
}

