/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.list.doublelist;

import io.datarouter.bytes.EmptyArray;
import io.datarouter.bytes.codec.doublecodec.RawDoubleCodec;
import java.util.ArrayList;
import java.util.List;

public class DoubleListCodec {
    public static final DoubleListCodec INSTANCE = new DoubleListCodec();
    private static final RawDoubleCodec RAW_DOUBLE_CODEC = RawDoubleCodec.INSTANCE;
    private static final int ITEM_LENGTH = RAW_DOUBLE_CODEC.length();

    public byte[] encode(List<Double> values) {
        if (values.isEmpty()) {
            return EmptyArray.BYTE;
        }
        byte[] bytes = new byte[ITEM_LENGTH * values.size()];
        int cursor = 0;
        int i = 0;
        while (i < values.size()) {
            RAW_DOUBLE_CODEC.encode(values.get(i), bytes, cursor);
            cursor += ITEM_LENGTH;
            ++i;
        }
        return bytes;
    }

    public List<Double> decode(byte[] bytes) {
        return this.decode(bytes, 0, bytes.length);
    }

    public List<Double> decode(byte[] bytes, int offset, int bytesLength) {
        if (bytesLength == 0) {
            return new ArrayList<Double>(0);
        }
        if (bytesLength % ITEM_LENGTH != 0) {
            throw new IllegalArgumentException("bytesLength must be multiple of " + ITEM_LENGTH);
        }
        int numValues = (bytes.length - offset) / ITEM_LENGTH;
        ArrayList<Double> values = new ArrayList<Double>(numValues);
        int cursor = offset;
        int i = 0;
        while (i < numValues) {
            double value = RAW_DOUBLE_CODEC.decode(bytes, cursor);
            cursor += ITEM_LENGTH;
            values.add(value);
            ++i;
        }
        return values;
    }
}

