/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.bytestringcodec;

import io.datarouter.bytes.codec.bytestringcodec.ByteStringCodec;
import io.datarouter.bytes.codec.stringcodec.StringCodec;

public class HexByteStringCodec
implements ByteStringCodec {
    public static final HexByteStringCodec INSTANCE = new HexByteStringCodec();
    private static final byte[] HEX_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final int[] VALUE_BY_HEX_DIGIT = new int[103];

    static {
        int value = 0;
        while (value < HEX_DIGITS.length) {
            byte index = HEX_DIGITS[value];
            HexByteStringCodec.VALUE_BY_HEX_DIGIT[index] = value++;
        }
    }

    @Override
    public String encode(byte[] bytes) {
        byte[] hexBytes = new byte[2 * bytes.length];
        int cursor = 0;
        int i = 0;
        while (i < bytes.length) {
            hexBytes[cursor] = HEX_DIGITS[(0xF0 & bytes[i]) >>> 4];
            hexBytes[++cursor] = HEX_DIGITS[0xF & bytes[i]];
            ++cursor;
            ++i;
        }
        return StringCodec.US_ASCII.decode(hexBytes);
    }

    @Override
    public byte[] decode(String hex) {
        int hexLength = hex.length();
        if (hexLength % 2 != 0) {
            throw new IllegalArgumentException("String length must be a multiple of 2");
        }
        int bytesLength = hexLength / 2;
        byte[] bytes = new byte[bytesLength];
        int hexCursor = 0;
        int bytesCursor = 0;
        while (hexCursor < hexLength) {
            char leftChar = hex.charAt(hexCursor);
            HexByteStringCodec.validateChar(leftChar);
            char rightChar = hex.charAt(++hexCursor);
            ++hexCursor;
            HexByteStringCodec.validateChar(rightChar);
            int leftPart = VALUE_BY_HEX_DIGIT[leftChar] << 4;
            int rightPart = VALUE_BY_HEX_DIGIT[rightChar];
            int byteValue = leftPart + rightPart;
            bytes[bytesCursor] = (byte)byteValue;
            ++bytesCursor;
        }
        return bytes;
    }

    private static void validateChar(char ch) {
        boolean validChar;
        boolean validDigit = ch >= '0' && ch <= '9';
        boolean bl = validChar = ch >= 'a' && ch <= 'f';
        if (!validDigit && !validChar) {
            throw new IllegalArgumentException("Invalid character=" + ch);
        }
    }
}

